/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTextVar;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkZTXT;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTextVar;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "parseFromRaw", "", "chunk", "Companion", "plot-api"})
public final class PngChunkZTXT
extends PngChunkTextVar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "zTXt";

    public PngChunkZTXT(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        block7: {
            block6: {
                if (this.getKey() == null) break block6;
                String string = this.getKey();
                Intrinsics.checkNotNull((Object)string);
                String $this$trim$iv = string;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) break block7;
            }
            throw new PngjException("Text chunk key must be non empty");
        }
        OutputPngStream ba = new OutputPngStream();
        String string = this.getKey();
        Intrinsics.checkNotNull((Object)string);
        ba.write(ChunkHelper.INSTANCE.toBytesLatin1(string));
        ba.write(0);
        ba.write(0);
        String string2 = this.getValue();
        Intrinsics.checkNotNull((Object)string2);
        byte[] textbytes = ChunkHelper.INSTANCE.compressBytes(ChunkHelper.INSTANCE.toBytesLatin1(string2), true);
        ba.write(textbytes);
        byte[] b = ba.getByteArray();
        ChunkRaw chunk = this.createEmptyChunk(b.length, false);
        chunk.setData(b);
        return chunk;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        int nullsep;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                nullsep = -1;
                byte[] byArray = chunk.getData();
                Intrinsics.checkNotNull((Object)byArray);
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    byte[] byArray2 = chunk.getData();
                    Intrinsics.checkNotNull((Object)byArray2);
                    if (byArray2[i] != 0) continue;
                    nullsep = i;
                    break;
                }
                if (nullsep < 0) break block5;
                byte[] byArray3 = chunk.getData();
                Intrinsics.checkNotNull((Object)byArray3);
                if (nullsep <= byArray3.length - 2) break block6;
            }
            throw new PngjException("bad zTXt chunk: no separator found");
        }
        byte[] byArray = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray);
        this.setKey(ChunkHelper.INSTANCE.toStringLatin1(byArray, 0, nullsep));
        byte[] byArray4 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray4);
        byte compmet = byArray4[nullsep + 1];
        if (compmet != 0) {
            throw new PngjException("bad zTXt chunk: unknown compression method");
        }
        byte[] byArray5 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray5);
        byte[] byArray6 = chunk.getData();
        Intrinsics.checkNotNull((Object)byArray6);
        byte[] uncomp = ChunkHelper.INSTANCE.compressBytes(byArray5, nullsep + 2, byArray6.length - nullsep - 2, false);
        this.setValue(ChunkHelper.INSTANCE.toStringLatin1(uncomp));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkZTXT$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

