/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public abstract class Animator {
    private static final ScheduledExecutorService scheduler = Animator.createScheduler();
    private final int totalFrames;
    private final int cycleDuration;
    private final boolean forward;
    private final boolean repeatable;
    private ScheduledFuture<?> ticker;
    private int startFrame;
    private int currentFrame;
    private long startTime;
    private long stopTime;
    private volatile boolean disposed = false;

    public Animator(String name, int totalFrames, int cycleDuration, boolean repeatable) {
        this(name, totalFrames, cycleDuration, repeatable, true);
    }

    public Animator(String name, int totalFrames, int cycleDuration, boolean repeatable, boolean forward) {
        this.totalFrames = totalFrames;
        this.cycleDuration = cycleDuration;
        this.repeatable = repeatable;
        this.forward = forward;
        this.currentFrame = forward ? 0 : totalFrames;
        this.resetTime();
        this.reset();
    }

    private void resetTime() {
        this.startTime = -1L;
    }

    public void reset() {
        this.currentFrame %= this.totalFrames;
        if (!this.forward) {
            this.currentFrame = this.totalFrames - this.currentFrame;
        }
    }

    private static ScheduledExecutorService createScheduler() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r, "Animations Thread");
            thread.setDaemon(true);
            thread.setPriority(10);
            return thread;
        });
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    public void suspend() {
        this.resetTime();
        this.reset();
        this.stopTicker();
    }

    private void stopTicker() {
        if (this.ticker != null) {
            this.ticker.cancel(false);
            this.ticker = null;
        }
    }

    public void resume() {
        this.resume(0);
    }

    public void resume(int startFrame) {
        if (startFrame < 0) {
            throw new IllegalArgumentException("Starting frame must be non negative.");
        }
        if (this.cycleDuration == 0 || startFrame >= this.totalFrames) {
            this.currentFrame = this.totalFrames - 1;
            this.paint();
            this.animationDone();
        } else if (this.ticker == null) {
            this.startFrame = startFrame;
            this.ticker = scheduler.scheduleWithFixedDelay(new Runnable(){
                final AtomicBoolean isScheduled = new AtomicBoolean(false);

                @Override
                public void run() {
                    if (!this.isScheduled.get() && !Animator.this.isDisposed()) {
                        this.isScheduled.set(true);
                        SwingUtilities.invokeLater(() -> {
                            Animator.this.onTick();
                            this.isScheduled.set(false);
                        });
                    }
                }
            }, 0L, this.cycleDuration * 1000 / this.totalFrames, TimeUnit.MICROSECONDS);
        }
    }

    private void paint() {
        this.paintNow(this.forward ? this.currentFrame : this.totalFrames - this.currentFrame - 1, this.totalFrames, this.cycleDuration);
    }

    private void animationDone() {
        this.stopTicker();
        SwingUtilities.invokeLater(this::paintCycleEnd);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void onTick() {
        if (this.isDisposed() || this.ticker == null) {
            return;
        }
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
            this.stopTime = this.startTime + (long)(this.cycleDuration * (this.totalFrames - this.currentFrame) / this.totalFrames);
        }
        double passedTime = System.currentTimeMillis() - this.startTime;
        double totalTime = this.stopTime - this.startTime;
        int newFrame = (int)(passedTime * (double)this.totalFrames / totalTime) + this.startFrame;
        if (this.currentFrame > 0 && newFrame == this.currentFrame) {
            return;
        }
        this.currentFrame = newFrame;
        if (this.currentFrame >= this.totalFrames) {
            if (this.repeatable) {
                this.reset();
            } else {
                this.animationDone();
                return;
            }
        }
        this.paint();
    }

    public abstract void paintNow(int var1, int var2, int var3);

    protected void paintCycleEnd() {
    }

    public void dispose() {
        this.disposed = true;
        this.stopTicker();
    }

    public boolean isRunning() {
        return this.ticker != null;
    }

    public final boolean isForward() {
        return this.forward;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public float getTotalFrames() {
        return this.totalFrames;
    }
}

