/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.Close;
import org.apache.jmeter.gui.action.Load;

public class LoadRecentProject
extends Load {
    private static final String USER_PREFS_KEY = "recent_file_";
    private static final int NUMBER_OF_MENU_ITEMS = 9;
    private static final Set<String> commands = new HashSet<String>();
    private static final Preferences prefs;

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doActionAfterCheck(ActionEvent e) {
        if (!Close.performAction(e)) {
            return;
        }
        LoadRecentProject.loadProjectFile(e, this.getRecentFile(e), false);
    }

    private File getRecentFile(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        return new File(LoadRecentProject.getRecentFile(Integer.parseInt(menuItem.getName())));
    }

    public static List<JComponent> getRecentFileMenuItems() {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        for (int i = 0; i < 9; ++i) {
            JMenuItem recentFile = new JMenuItem();
            recentFile.setName(Integer.toString(i));
            recentFile.addActionListener(ActionRouter.getInstance());
            recentFile.setActionCommand("open_recent");
            int shortKey = LoadRecentProject.getShortcutKey(i);
            if (shortKey >= 0) {
                recentFile.setMnemonic(shortKey);
            }
            menuItems.add(recentFile);
        }
        LoadRecentProject.updateMenuItems(menuItems);
        return menuItems;
    }

    public static void updateRecentFileMenuItems(List<JComponent> menuItems, String loadedFileName) {
        ArrayDeque<String> newRecentFiles = new ArrayDeque<String>();
        boolean alreadyExists = false;
        for (int i = 0; i < 9; ++i) {
            String recentFilePath = LoadRecentProject.getRecentFile(i);
            if (!loadedFileName.equals(recentFilePath)) {
                newRecentFiles.add(recentFilePath);
                continue;
            }
            alreadyExists = true;
        }
        newRecentFiles.addFirst(loadedFileName);
        if (!alreadyExists) {
            newRecentFiles.removeLast();
        }
        int index = 0;
        for (String fileName : newRecentFiles) {
            if (fileName == null) continue;
            LoadRecentProject.setRecentFile(index, fileName);
            if (++index < 9) continue;
            break;
        }
        LoadRecentProject.updateMenuItems(menuItems);
    }

    private static void updateMenuItems(List<JComponent> menuItems) {
        for (int i = 0; i < 9; ++i) {
            JMenuItem recentFile = (JMenuItem)menuItems.get(i);
            String recentFilePath = LoadRecentProject.getRecentFile(i);
            if (recentFilePath != null) {
                File file = new File(recentFilePath);
                String sb = String.valueOf(i + 1) + " " + LoadRecentProject.getMenuItemDisplayName(file);
                recentFile.setText(sb);
                recentFile.setToolTipText(recentFilePath);
                recentFile.setEnabled(true);
                recentFile.setVisible(true);
                continue;
            }
            recentFile.setEnabled(false);
            recentFile.setVisible(false);
        }
    }

    private static String getMenuItemDisplayName(File file) {
        int maxLength = 40;
        String menuText = file.getName();
        if (menuText.length() > 40) {
            menuText = "..." + menuText.substring(menuText.length() - 40, menuText.length());
        }
        return menuText;
    }

    private static int getShortcutKey(int index) {
        int shortKey = -1;
        switch (index + 1) {
            case 1: {
                shortKey = 49;
                break;
            }
            case 2: {
                shortKey = 50;
                break;
            }
            case 3: {
                shortKey = 51;
                break;
            }
            case 4: {
                shortKey = 52;
                break;
            }
            case 5: {
                shortKey = 53;
                break;
            }
            case 6: {
                shortKey = 54;
                break;
            }
            case 7: {
                shortKey = 55;
                break;
            }
            case 8: {
                shortKey = 56;
                break;
            }
            case 9: {
                shortKey = 57;
                break;
            }
        }
        return shortKey;
    }

    public static String getRecentFile(int index) {
        return prefs.get(USER_PREFS_KEY + index, null);
    }

    private static void setRecentFile(int index, String fileName) {
        prefs.put(USER_PREFS_KEY + index, fileName);
    }

    public static boolean hasVisibleMenuItem(List<JComponent> fileLoadRecentFiles) {
        return fileLoadRecentFiles.stream().anyMatch(Component::isVisible);
    }

    static {
        commands.add("open_recent");
        prefs = Preferences.userNodeForPackage(LoadRecentProject.class);
    }
}

