/*
 * Decompiled with CFR 0.152.
 */
package jodd.net;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import jodd.io.StreamUtil;
import jodd.util.StringPool;
import jodd.util.StringUtil;
import jodd.util.Wildcard;

public class MimeTypes {
    public static final String MIME_APPLICATION_ATOM_XML = "application/atom+xml";
    public static final String MIME_APPLICATION_JAVASCRIPT = "application/javascript";
    public static final String MIME_APPLICATION_JSON = "application/json";
    public static final String MIME_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MIME_APPLICATION_XML = "application/xml";
    public static final String MIME_TEXT_CSS = "text/css";
    public static final String MIME_TEXT_PLAIN = "text/plain";
    public static final String MIME_TEXT_HTML = "text/html";
    private static final LinkedHashMap<String, String> MIME_TYPE_MAP;

    public static void registerMimeType(String ext, String mimeType) {
        MIME_TYPE_MAP.put(ext, mimeType);
    }

    public static String getMimeType(String ext) {
        String mimeType = MimeTypes.lookupMimeType(ext);
        if (mimeType == null) {
            mimeType = MIME_APPLICATION_OCTET_STREAM;
        }
        return mimeType;
    }

    public static String lookupMimeType(String ext) {
        return MIME_TYPE_MAP.get(ext.toLowerCase());
    }

    public static String[] findExtensionsByMimeTypes(String mimeType, boolean useWildcard) {
        ArrayList<String> extensions = new ArrayList<String>();
        mimeType = mimeType.toLowerCase();
        String[] mimeTypes = StringUtil.splitc(mimeType, ", ");
        for (Map.Entry<String, String> entry : MIME_TYPE_MAP.entrySet()) {
            String entryExtension = entry.getKey();
            String entryMimeType = entry.getValue().toLowerCase();
            int matchResult = useWildcard ? Wildcard.matchOne(entryMimeType, mimeTypes) : StringUtil.equalsOne(entryMimeType, mimeTypes);
            if (matchResult == -1) continue;
            extensions.add(entryExtension);
        }
        if (extensions.isEmpty()) {
            return StringPool.EMPTY_ARRAY;
        }
        return extensions.toArray(new String[0]);
    }

    public static boolean isRegisteredExtension(String extension) {
        return MIME_TYPE_MAP.containsKey(extension);
    }

    static {
        Properties mimes = new Properties();
        InputStream is = MimeTypes.class.getResourceAsStream(MimeTypes.class.getSimpleName() + ".properties");
        if (is == null) {
            throw new IllegalStateException("Mime types file missing");
        }
        try {
            mimes.load(is);
        }
        catch (IOException ioex) {
            throw new IllegalStateException("Can't load properties", ioex);
        }
        finally {
            StreamUtil.close(is);
        }
        MIME_TYPE_MAP = new LinkedHashMap(mimes.size() * 2);
        Enumeration<?> keys = mimes.propertyNames();
        while (keys.hasMoreElements()) {
            String[] allExtensions;
            String mimeType = (String)keys.nextElement();
            String extensions = mimes.getProperty(mimeType);
            if (mimeType.startsWith("/")) {
                mimeType = "application" + mimeType;
            } else if (mimeType.startsWith("a/")) {
                mimeType = "audio" + mimeType.substring(1);
            } else if (mimeType.startsWith("i/")) {
                mimeType = "image" + mimeType.substring(1);
            } else if (mimeType.startsWith("t/")) {
                mimeType = "text" + mimeType.substring(1);
            } else if (mimeType.startsWith("v/")) {
                mimeType = "video" + mimeType.substring(1);
            }
            for (String extension : allExtensions = StringUtil.splitc(extensions, ' ')) {
                if (MIME_TYPE_MAP.put(extension, mimeType) == null) continue;
                throw new IllegalArgumentException("Duplicated extension: " + extension);
            }
        }
    }
}

