/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.sql.Date;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.exparity.hamcrest.date.DayMonthYear;
import org.exparity.hamcrest.date.Months;
import org.exparity.hamcrest.date.Weekdays;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsFirstDayOfMonth;
import org.exparity.hamcrest.date.core.IsLastDayOfMonth;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.TemporalConverters;
import org.exparity.hamcrest.date.core.TemporalFunctions;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProviders;
import org.exparity.hamcrest.date.core.types.Interval;

public abstract class SqlDateMatchers {
    public static TemporalMatcher<Date> after(Date date) {
        return new IsAfter<Date, Date>(TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<Date> after(java.util.Date date) {
        return new IsAfter<Date, Date>(TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    @Deprecated
    public static TemporalMatcher<Date> after(DayMonthYear date) {
        return SqlDateMatchers.after(date.toLocalDate());
    }

    public static TemporalMatcher<Date> after(LocalDate date) {
        return new IsAfter<Date, LocalDate>(TemporalConverters.SQLDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    @Deprecated
    public static TemporalMatcher<Date> after(int year, Months month, int day) {
        return SqlDateMatchers.after(year, month.month(), day);
    }

    public static TemporalMatcher<Date> after(int year, Month month, int day) {
        return SqlDateMatchers.after(LocalDate.of(year, month, day));
    }

    public static TemporalMatcher<Date> before(Date date) {
        return new IsBefore<Date, Date>(TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<Date> before(java.util.Date date) {
        return new IsBefore<Date, Date>(TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    @Deprecated
    public static TemporalMatcher<Date> before(DayMonthYear date) {
        return SqlDateMatchers.before(date.toLocalDate());
    }

    public static TemporalMatcher<Date> before(LocalDate date) {
        return new IsBefore<Date, LocalDate>(TemporalConverters.SQLDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    @Deprecated
    public static TemporalMatcher<Date> before(int year, Months month, int day) {
        return SqlDateMatchers.before(year, month.month(), day);
    }

    public static TemporalMatcher<Date> before(int year, Month month, int day) {
        return SqlDateMatchers.before(LocalDate.of(year, month, day));
    }

    public static TemporalMatcher<Date> sameDayOfWeek(Date date) {
        return SqlDateMatchers.isDayOfWeek(SqlDateMatchers.toDayOfWeek(date));
    }

    public static TemporalMatcher<Date> sameDayOfWeek(java.util.Date date) {
        return SqlDateMatchers.isDayOfWeek(SqlDateMatchers.toDayOfWeek(date, ZoneId.systemDefault()));
    }

    @Deprecated
    public static TemporalMatcher<Date> isDayOfWeek(Weekdays dayOfWeek) {
        return SqlDateMatchers.isDayOfWeek(dayOfWeek.getAsDayOfWeek());
    }

    public static TemporalMatcher<Date> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<Date>(TemporalConverters.SQLDATE_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(dayOfWeek));
    }

    public static TemporalMatcher<Date> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new IsDayOfWeek<Date>(TemporalConverters.SQLDATE_AS_DAYOFWEEK, TemporalProviders.daysOfWeek(daysOfWeek));
    }

    public static TemporalMatcher<Date> sameDayOfMonth(Date date) {
        return new IsDayOfMonth<Date>(TemporalConverters.SQLDATE_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(date));
    }

    public static TemporalMatcher<Date> sameDayOfMonth(java.util.Date date) {
        return new IsDayOfMonth<Date>(TemporalConverters.SQLDATE_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(date));
    }

    public static TemporalMatcher<Date> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<Date>(TemporalConverters.SQLDATE_AS_DAYOFMONTH, TemporalProviders.dayOfMonth(dayOfMonth));
    }

    public static TemporalMatcher<Date> sameDay(Date date) {
        return new IsSameDay<Date>(TemporalConverters.SQLDATE_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    @Deprecated
    public static TemporalMatcher<Date> sameDay(DayMonthYear date) {
        return SqlDateMatchers.sameDay(date.toLocalDate());
    }

    public static TemporalMatcher<Date> sameDay(LocalDate date) {
        return new IsSameDay<Date>(TemporalConverters.SQLDATE_AS_LOCALDATE, TemporalProviders.localDate(date));
    }

    @Deprecated
    public static TemporalMatcher<Date> sameDay(int year, Months month, int day) {
        return SqlDateMatchers.isDay(year, month.month(), day);
    }

    public static TemporalMatcher<Date> isDay(int year, Month month, int dayOfMonth) {
        return SqlDateMatchers.sameDay(LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<Date> sameOrBefore(Date date) {
        return new IsSameOrBefore<Date, Date>(TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<Date> sameOrBefore(java.util.Date date) {
        return new IsSameOrBefore<Date, Date>(TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<Date> sameOrBefore(LocalDate date) {
        return new IsSameOrBefore<Date, LocalDate>(TemporalConverters.SQLDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    @Deprecated
    public static TemporalMatcher<Date> sameOrBefore(DayMonthYear date) {
        return SqlDateMatchers.sameOrBefore(date.toLocalDate());
    }

    @Deprecated
    public static TemporalMatcher<Date> sameOrBefore(int year, Months month, int dayOfMonth) {
        return SqlDateMatchers.sameOrBefore(year, month.month(), dayOfMonth);
    }

    public static TemporalMatcher<Date> sameOrBefore(int year, Month month, int dayOfMonth) {
        return SqlDateMatchers.sameOrBefore(LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<Date> sameOrAfter(Date date) {
        return new IsSameOrAfter<Date, Date>(TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<Date> sameOrAfter(java.util.Date date) {
        return new IsSameOrAfter<Date, Date>(TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<Date> sameOrAfter(LocalDate date) {
        return new IsSameOrAfter<Date, LocalDate>(TemporalConverters.SQLDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    @Deprecated
    public static TemporalMatcher<Date> sameOrAfter(DayMonthYear date) {
        return SqlDateMatchers.sameOrAfter(date.toLocalDate());
    }

    @Deprecated
    public static TemporalMatcher<Date> sameOrAfter(int year, Months month, int dayOfMonth) {
        return SqlDateMatchers.sameOrAfter(year, month.month(), dayOfMonth);
    }

    public static TemporalMatcher<Date> sameOrAfter(int year, Month month, int dayOfMonth) {
        return SqlDateMatchers.sameOrAfter(LocalDate.of(year, month, dayOfMonth));
    }

    @Deprecated
    public static TemporalMatcher<Date> sameMonth(Date date) {
        return SqlDateMatchers.sameMonthOfYear(date);
    }

    @Deprecated
    public static TemporalMatcher<Date> sameMonth(java.util.Date date) {
        return SqlDateMatchers.sameMonthOfYear(date);
    }

    public static TemporalMatcher<Date> sameMonthOfYear(Date date) {
        return new IsMonth<Date>(TemporalConverters.SQLDATE_AS_MONTH, TemporalProviders.month(date));
    }

    public static TemporalMatcher<Date> sameMonthOfYear(java.util.Date date) {
        return SqlDateMatchers.isMonth(SqlDateMatchers.toMonth(date, ZoneId.systemDefault()));
    }

    @Deprecated
    public static TemporalMatcher<Date> sameMonth(Months month) {
        return SqlDateMatchers.sameMonthOfYear(month);
    }

    @Deprecated
    public static TemporalMatcher<Date> sameMonthOfYear(Months month) {
        return SqlDateMatchers.isMonth(month.month());
    }

    public static TemporalMatcher<Date> sameYear(Date date) {
        return new IsYear<Date>(TemporalConverters.SQLDATE_AS_YEAR, TemporalProviders.year(date));
    }

    public static TemporalMatcher<Date> sameYear(java.util.Date date) {
        return new IsYear<Date>(TemporalConverters.SQLDATE_AS_YEAR, TemporalProviders.year(date));
    }

    public static TemporalMatcher<Date> isYear(int year) {
        return new IsYear<Date>(TemporalConverters.SQLDATE_AS_YEAR, TemporalProviders.year(year));
    }

    @Deprecated
    public static TemporalMatcher<Date> within(long period, TimeUnit unit, Date date) {
        return SqlDateMatchers.within(period, SqlDateMatchers.convertUnit(unit), date);
    }

    @Deprecated
    public static TemporalMatcher<Date> within(long period, TimeUnit unit, java.util.Date date) {
        return SqlDateMatchers.within(period, SqlDateMatchers.convertUnit(unit), date);
    }

    public static TemporalMatcher<Date> within(long period, ChronoUnit unit, Date date) {
        return new IsWithin<Date, Date>(Interval.of(period, unit), TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<Date> within(long period, ChronoUnit unit, java.util.Date date) {
        return new IsWithin<Date, Date>(Interval.of(period, unit), TemporalConverters.SQLDATE_AS_SQLDATE, TemporalProviders.sqlDate(date), TemporalFunctions.SQLDATE);
    }

    public static TemporalMatcher<Date> within(long period, ChronoUnit unit, LocalDate date) {
        return new IsWithin<Date, LocalDate>(Interval.of(period, unit), TemporalConverters.SQLDATE_AS_LOCALDATE, TemporalProviders.localDate(date), TemporalFunctions.LOCALDATE);
    }

    @Deprecated
    public static TemporalMatcher<Date> within(long period, TimeUnit unit, DayMonthYear date) {
        return SqlDateMatchers.within(period, SqlDateMatchers.convertUnit(unit), date.toLocalDate());
    }

    @Deprecated
    public static TemporalMatcher<Date> within(long period, TimeUnit unit, int year, Months month, int dayOfMonth) {
        return SqlDateMatchers.within(period, SqlDateMatchers.convertUnit(unit), year, month.month(), dayOfMonth);
    }

    public static TemporalMatcher<Date> within(long period, ChronoUnit unit, int year, Month month, int dayOfMonth) {
        return SqlDateMatchers.within(period, unit, LocalDate.of(year, month, dayOfMonth));
    }

    public static TemporalMatcher<Date> isYesterday() {
        return SqlDateMatchers.sameDay(LocalDate.now().minusDays(1L));
    }

    public static TemporalMatcher<Date> isToday() {
        return SqlDateMatchers.sameDay(LocalDate.now());
    }

    public static TemporalMatcher<Date> isTomorrow() {
        return SqlDateMatchers.sameDay(LocalDate.now().plusDays(1L));
    }

    public static TemporalMatcher<Date> isMonday() {
        return SqlDateMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static TemporalMatcher<Date> isTuesday() {
        return SqlDateMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static TemporalMatcher<Date> isWednesday() {
        return SqlDateMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static TemporalMatcher<Date> isThursday() {
        return SqlDateMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static TemporalMatcher<Date> isFriday() {
        return SqlDateMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<Date> isSaturday() {
        return SqlDateMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static TemporalMatcher<Date> isSunday() {
        return SqlDateMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<Date> isWeekday() {
        return SqlDateMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static TemporalMatcher<Date> isWeekend() {
        return SqlDateMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static TemporalMatcher<Date> isFirstDayOfMonth() {
        return new IsFirstDayOfMonth<Date>(TemporalConverters.SQLDATE_AS_LOCALDATE);
    }

    public static TemporalMatcher<Date> isMinimum(ChronoField field) {
        return new IsMinimum<Date>(TemporalConverters.SQLDATE_AS_LOCALDATE, field);
    }

    public static TemporalMatcher<Date> isLastDayOfMonth() {
        return new IsLastDayOfMonth<Date>(TemporalConverters.SQLDATE_AS_LOCALDATE);
    }

    public static TemporalMatcher<Date> isMaximum(ChronoField field) {
        return new IsMaximum<Date>(TemporalConverters.SQLDATE_AS_LOCALDATE, field);
    }

    public static TemporalMatcher<Date> isMonth(Month month) {
        return new IsMonth<Date>(TemporalConverters.SQLDATE_AS_MONTH, TemporalProviders.month(month));
    }

    public static TemporalMatcher<Date> isJanuary() {
        return SqlDateMatchers.isMonth(Month.JANUARY);
    }

    public static TemporalMatcher<Date> isFebruary() {
        return SqlDateMatchers.isMonth(Month.FEBRUARY);
    }

    public static TemporalMatcher<Date> isMarch() {
        return SqlDateMatchers.isMonth(Month.MARCH);
    }

    public static TemporalMatcher<Date> isApril() {
        return SqlDateMatchers.isMonth(Month.APRIL);
    }

    public static TemporalMatcher<Date> isMay() {
        return SqlDateMatchers.isMonth(Month.MAY);
    }

    public static TemporalMatcher<Date> isJune() {
        return SqlDateMatchers.isMonth(Month.JUNE);
    }

    public static TemporalMatcher<Date> isJuly() {
        return SqlDateMatchers.isMonth(Month.JULY);
    }

    public static TemporalMatcher<Date> isAugust() {
        return SqlDateMatchers.isMonth(Month.AUGUST);
    }

    public static TemporalMatcher<Date> isSeptember() {
        return SqlDateMatchers.isMonth(Month.SEPTEMBER);
    }

    public static TemporalMatcher<Date> isOctober() {
        return SqlDateMatchers.isMonth(Month.OCTOBER);
    }

    public static TemporalMatcher<Date> isNovember() {
        return SqlDateMatchers.isMonth(Month.NOVEMBER);
    }

    public static TemporalMatcher<Date> isDecember() {
        return SqlDateMatchers.isMonth(Month.DECEMBER);
    }

    public static TemporalMatcher<Date> isLeapYear() {
        return new IsLeapYear<Date>(TemporalConverters.SQLDATE_AS_YEAR);
    }

    private static ChronoUnit convertUnit(TimeUnit unit) {
        switch (unit) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
        }
        throw new IllegalArgumentException("Unknown TimeUnit '" + (Object)((Object)unit) + "'");
    }

    private static DayOfWeek toDayOfWeek(Date date) {
        return date.toLocalDate().getDayOfWeek();
    }

    private static DayOfWeek toDayOfWeek(java.util.Date date, ZoneId zone) {
        return date.toInstant().atZone(zone).getDayOfWeek();
    }

    private static Month toMonth(java.util.Date date, ZoneId zone) {
        return date.toInstant().atZone(zone).getMonth();
    }
}

