/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.focus;

import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class FocusParentHelper {
    public static final String KEY_FOCUS_PARENT = "focusParent";
    public static final String KEY_FOCUS_ACTION = "focusOnParentChangedAction";
    private static final Map<Component, Component> listeners = new WeakHashMap<Component, Component>();

    public static void setFocusParent(JComponent c, JComponent focusParent) {
        FocusParentHelper.setFocusParent(c, focusParent, Component::repaint);
    }

    public static void setFocusParent(JComponent c, JComponent focusParent, RepaintAction focusChangedAction) {
        if (c == null) {
            return;
        }
        c.putClientProperty(KEY_FOCUS_PARENT, focusParent);
        if (focusParent == null) {
            c.putClientProperty(KEY_FOCUS_ACTION, null);
            listeners.remove(c);
        } else {
            c.putClientProperty(KEY_FOCUS_ACTION, focusChangedAction);
            listeners.put(c, focusParent);
        }
    }

    static {
        Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
            if (!(event instanceof FocusEvent)) {
                return;
            }
            FocusEvent e = (FocusEvent)event;
            if (e.getID() != 1004 && e.getID() != 1005) {
                return;
            }
            Component comp = e.getComponent();
            listeners.forEach((c, focusParent) -> {
                RepaintAction repaintAction;
                if (SwingUtilities.isDescendingFrom(comp, focusParent) && (repaintAction = (RepaintAction)PropertyUtil.getObject((Component)c, (String)KEY_FOCUS_ACTION, RepaintAction.class)) != null) {
                    repaintAction.accept(c);
                }
            });
        }, 4L);
    }

    public static interface RepaintAction
    extends Consumer<Component> {
    }
}

