/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.TreeCloner;
import org.apache.jmeter.engine.TreeClonerNoTimer;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.Copy;
import org.apache.jmeter.gui.action.validation.TreeClonerForValidation;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Start
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(Start.class);
    private static final Set<String> commands = new HashSet<String>();
    private static final String VALIDATION_CLONER_CLASS_PROPERTY_NAME = "testplan_validation.tree_cloner_class";
    private static final String CLONER_FOR_VALIDATION_CLASS_NAME = JMeterUtils.getPropDefault("testplan_validation.tree_cloner_class", "org.apache.jmeter.validation.ComponentTreeClonerForValidation");
    private StandardJMeterEngine engine;

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public void doAction(ActionEvent e) {
        if (e.getActionCommand().equals("start")) {
            this.popupShouldSave(e);
            this.startEngine(null, RunMode.AS_IS);
        } else if (e.getActionCommand().equals("start_no_timers")) {
            this.popupShouldSave(e);
            this.startEngine(null, RunMode.IGNORING_TIMERS);
        } else if (e.getActionCommand().equals("stop")) {
            if (this.engine != null) {
                log.info("Stopping test");
                GuiPackage.getInstance().getMainFrame().showStoppingMessage("");
                this.engine.stopTest();
            }
        } else if (e.getActionCommand().equals("shutdown")) {
            if (this.engine != null) {
                log.info("Shutting test down");
                GuiPackage.getInstance().getMainFrame().showStoppingMessage("");
                this.engine.askThreadsToStop();
            }
        } else if (e.getActionCommand().equals("run_tg") || e.getActionCommand().equals("run_tg_no_timers") || e.getActionCommand().equals("validate_tg")) {
            this.popupShouldSave(e);
            boolean noTimers = e.getActionCommand().equals("run_tg_no_timers");
            boolean isValidation = e.getActionCommand().equals("validate_tg");
            RunMode runMode = null;
            runMode = isValidation ? RunMode.VALIDATION : (noTimers ? RunMode.IGNORING_TIMERS : RunMode.AS_IS);
            JMeterTreeListener treeListener = GuiPackage.getInstance().getTreeListener();
            JMeterTreeNode[] nodes = treeListener.getSelectedNodes();
            nodes = Copy.keepOnlyAncestors(nodes);
            AbstractThreadGroup[] tg = this.keepOnlyThreadGroups(nodes);
            if (nodes.length > 0) {
                this.startEngine(tg, runMode);
            } else {
                log.warn("No thread group selected the test will not be started");
            }
        }
    }

    private AbstractThreadGroup[] keepOnlyThreadGroups(JMeterTreeNode[] currentNodes) {
        ArrayList<AbstractThreadGroup> nodes = new ArrayList<AbstractThreadGroup>();
        for (JMeterTreeNode jMeterTreeNode : currentNodes) {
            if (!(jMeterTreeNode.getTestElement() instanceof AbstractThreadGroup)) continue;
            nodes.add((AbstractThreadGroup)jMeterTreeNode.getTestElement());
        }
        return nodes.toArray(new AbstractThreadGroup[nodes.size()]);
    }

    private void startEngine(AbstractThreadGroup[] threadGroupsToRun, RunMode runMode) {
        ListedHashTree clonedTree;
        GuiPackage gui = GuiPackage.getInstance();
        HashTree testTree = gui.getTreeModel().getTestPlan();
        HashTree treeToUse = JMeter.convertSubTree(testTree, false);
        if (threadGroupsToRun != null && threadGroupsToRun.length > 0) {
            this.keepOnlySelectedThreadGroupsInHashTree(treeToUse, threadGroupsToRun);
        }
        treeToUse.add(treeToUse.getArray()[0], (Object)gui.getMainFrame());
        if (log.isDebugEnabled()) {
            log.debug("test plan before cloning is running version: {}", (Object)((TestPlan)treeToUse.getArray()[0]).isRunningVersion());
        }
        if (this.popupCheckExistingFileListener((HashTree)(clonedTree = this.cloneTree(treeToUse, runMode)))) {
            this.engine = new StandardJMeterEngine();
            this.engine.configure((HashTree)clonedTree);
            try {
                this.engine.runTest();
            }
            catch (JMeterEngineException e) {
                JOptionPane.showMessageDialog(gui.getMainFrame(), e.getMessage(), JMeterUtils.getResString("error_occurred"), 0);
            }
            if (log.isDebugEnabled()) {
                log.debug("test plan after cloning and running test is running version: {}", (Object)((TestPlan)treeToUse.getArray()[0]).isRunningVersion());
            }
        }
    }

    private static TreeCloner createTreeClonerForValidation(boolean honorThreadClone) {
        try {
            Class<?> clazz = Class.forName(CLONER_FOR_VALIDATION_CLASS_NAME, true, Thread.currentThread().getContextClassLoader());
            return (TreeCloner)clazz.getConstructor(Boolean.TYPE).newInstance(honorThreadClone);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.error("Error instantiating class:'{}' defined in property:'{}'", new Object[]{CLONER_FOR_VALIDATION_CLASS_NAME, VALIDATION_CLONER_CLASS_PROPERTY_NAME, ex});
            return new TreeClonerForValidation(honorThreadClone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepOnlySelectedThreadGroupsInHashTree(HashTree testTree, AbstractThreadGroup[] threadGroupsToKeep) {
        for (Object o : new ArrayList(testTree.list())) {
            TestElement item = (TestElement)o;
            if (o instanceof AbstractThreadGroup) {
                if (!this.isInThreadGroups(item, threadGroupsToKeep)) {
                    try {
                        item.setEnabled(false);
                        testTree.remove((Object)item);
                        continue;
                    }
                    finally {
                        item.setEnabled(true);
                        continue;
                    }
                }
                this.keepOnlySelectedThreadGroupsInHashTree(testTree.getTree((Object)item), threadGroupsToKeep);
                continue;
            }
            this.keepOnlySelectedThreadGroupsInHashTree(testTree.getTree((Object)item), threadGroupsToKeep);
        }
    }

    private boolean isInThreadGroups(TestElement item, AbstractThreadGroup[] threadGroups) {
        for (AbstractThreadGroup abstractThreadGroup : threadGroups) {
            if (item != abstractThreadGroup) continue;
            return true;
        }
        return false;
    }

    private ListedHashTree cloneTree(HashTree testTree, RunMode runMode) {
        TreeCloner cloner = null;
        switch (runMode) {
            case VALIDATION: {
                cloner = Start.createTreeClonerForValidation(false);
                break;
            }
            case IGNORING_TIMERS: {
                cloner = new TreeClonerNoTimer(false);
                break;
            }
            default: {
                cloner = new TreeCloner(false);
            }
        }
        testTree.traverse((HashTreeTraverser)cloner);
        return cloner.getClonedTree();
    }

    static {
        commands.add("start");
        commands.add("start_no_timers");
        commands.add("stop");
        commands.add("shutdown");
        commands.add("run_tg");
        commands.add("run_tg_no_timers");
        commands.add("validate_tg");
    }

    private static enum RunMode {
        AS_IS,
        IGNORING_TIMERS,
        VALIDATION;

    }
}

