/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;

public class Move
extends AbstractAction {
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        JMeterTreeListener treeListener = GuiPackage.getInstance().getTreeListener();
        if (treeListener.getSelectedNodes().length != 1) {
            return;
        }
        JMeterTreeNode currentNode = treeListener.getCurrentNode();
        JMeterTreeNode parentNode = this.getParentNode(currentNode);
        if (parentNode != null) {
            JMeterTreeNode after;
            String action = e.getActionCommand();
            int index = parentNode.getIndex(currentNode);
            if ("move_up".equals(action)) {
                if (index > 0) {
                    int newIndx = index - 1;
                    Move.moveAndSelectNode(currentNode, parentNode, newIndx);
                }
            } else if ("move_down".equals(action)) {
                if (index < parentNode.getChildCount() - 1) {
                    int newIndx = index + 1;
                    Move.moveAndSelectNode(currentNode, parentNode, newIndx);
                }
            } else if ("move_left".equals(action)) {
                JMeterTreeNode parentParentNode = this.getParentNode(parentNode);
                if (parentParentNode != null && Move.canAddTo(parentParentNode, currentNode)) {
                    Move.moveAndSelectNode(currentNode, parentParentNode, parentParentNode.getIndex(parentNode));
                }
            } else if ("move_right".equals(action) && (after = (JMeterTreeNode)parentNode.getChildAfter(currentNode)) != null && Move.canAddTo(after, currentNode)) {
                Move.moveAndSelectNode(currentNode, after, 0);
            }
        }
        GuiPackage.getInstance().getMainFrame().repaint();
    }

    private JMeterTreeNode getParentNode(JMeterTreeNode currentNode) {
        JMeterTreeNode parentNode = (JMeterTreeNode)currentNode.getParent();
        TestElement te = currentNode.getTestElement();
        if (te instanceof TestPlan) {
            parentNode = null;
        }
        return parentNode;
    }

    private static boolean canAddTo(JMeterTreeNode parentNode, JMeterTreeNode node) {
        boolean ok = MenuFactory.canAddTo(parentNode, new JMeterTreeNode[]{node});
        if (!ok) {
            Toolkit.getDefaultToolkit().beep();
        }
        return ok;
    }

    private static void moveAndSelectNode(JMeterTreeNode currentNode, JMeterTreeNode parentNode, int newIndx) {
        GuiPackage guiInstance = GuiPackage.getInstance();
        guiInstance.getTreeModel().removeNodeFromParent(currentNode);
        guiInstance.getTreeModel().insertNodeInto(currentNode, parentNode, newIndx);
        Object[] nodes = guiInstance.getTreeModel().getPathToRoot(currentNode);
        JTree jTree = guiInstance.getMainFrame().getTree();
        jTree.setSelectionPath(new TreePath(nodes));
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("move_down");
        commands.add("move_up");
        commands.add("move_left");
        commands.add("move_right");
    }
}

