/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.IteratingController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhileController
extends GenericController
implements Serializable,
IteratingController {
    private static final Logger log = LoggerFactory.getLogger(WhileController.class);
    private static final long serialVersionUID = 233L;
    private static final String CONDITION = "WhileController.condition";
    private boolean breakLoop;

    private boolean endOfLoop(boolean loopEnd) {
        boolean res;
        if (this.breakLoop) {
            return true;
        }
        String cnd = this.getCondition().trim();
        log.debug("Condition string: '{}'", (Object)cnd);
        if (loopEnd && cnd.isEmpty() || "LAST".equalsIgnoreCase(cnd)) {
            JMeterVariables threadVars = JMeterContextService.getContext().getVariables();
            res = "false".equalsIgnoreCase(threadVars.get("JMeterThread.last_sample_ok"));
        } else {
            res = "false".equalsIgnoreCase(cnd);
        }
        log.debug("Condition value: '{}'", (Object)res);
        return res;
    }

    @Override
    protected Sampler nextIsNull() throws NextIsNullException {
        this.reInitialize();
        if (this.endOfLoop(true)) {
            this.resetBreakLoop();
            this.resetLoopCount();
            return null;
        }
        return this.next();
    }

    @Override
    public void triggerEndOfLoop() {
        super.triggerEndOfLoop();
        this.endOfLoop(true);
        this.resetLoopCount();
    }

    @Override
    public Sampler next() {
        this.updateIterationIndex(this.getName(), this.getIterCount());
        try {
            if (this.isFirst() && this.endOfLoop(false)) {
                this.resetBreakLoop();
                this.resetLoopCount();
                Sampler sampler = null;
                return sampler;
            }
            Sampler sampler = super.next();
            return sampler;
        }
        finally {
            this.updateIterationIndex(this.getName(), this.getIterCount());
        }
    }

    protected void resetLoopCount() {
        this.resetIterCount();
    }

    public void setCondition(String string) {
        log.debug("setCondition({})", (Object)string);
        this.setProperty(new StringProperty(CONDITION, string));
    }

    public String getCondition() {
        JMeterProperty prop = this.getProperty(CONDITION);
        prop.recoverRunningVersion(this);
        return prop.getStringValue();
    }

    @Override
    public void startNextLoop() {
        this.reInitialize();
    }

    private void resetBreakLoop() {
        if (this.breakLoop) {
            this.breakLoop = false;
        }
    }

    @Override
    public void breakLoop() {
        this.breakLoop = true;
        this.setFirst(true);
        this.resetCurrent();
        this.resetLoopCount();
        this.recoverRunningVersion();
    }

    @Override
    public void iterationStart(LoopIterationEvent iterEvent) {
        this.reInitialize();
        this.resetLoopCount();
    }
}

