/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxHide;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.ParallelFlux;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Publisher;

final class ParallelLiftFuseable<I, O>
extends ParallelFlux<O>
implements Scannable,
Fuseable {
    final BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter;
    final ParallelFlux<I> source;

    ParallelLiftFuseable(ParallelFlux<I> p, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super I>> lifter) {
        this.source = Objects.requireNonNull(p, "source");
        this.lifter = lifter;
    }

    @Override
    public int getPrefetch() {
        return this.source.getPrefetch();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        return null;
    }

    @Override
    public String stepName() {
        if (this.source instanceof Scannable) {
            return Scannable.from(this.source).stepName();
        }
        return Scannable.super.stepName();
    }

    @Override
    protected void subscribe(CoreSubscriber<? super O>[] s) {
        CoreSubscriber[] subscribers = new CoreSubscriber[this.parallelism()];
        for (int i = 0; i < subscribers.length; ++i) {
            CoreSubscriber<? super O> actual = s[i];
            CoreSubscriber<? super I> converted = Objects.requireNonNull(this.lifter.apply(this.source, actual), "Lifted subscriber MUST NOT be null");
            Objects.requireNonNull(converted, "Lifted subscriber MUST NOT be null");
            if (actual instanceof Fuseable.QueueSubscription && !(converted instanceof Fuseable.QueueSubscription)) {
                converted = new FluxHide.SuppressFuseableSubscriber<I>(converted);
            }
            subscribers[i] = converted;
        }
        this.source.subscribe(subscribers);
    }
}

