/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.apache.jorphan.collections.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerTableModel
extends DefaultTableModel {
    private static final Logger log = LoggerFactory.getLogger(PowerTableModel.class);
    private static final long serialVersionUID = 234L;
    private Data model = new Data();
    private Class<?>[] columnClasses;
    private static final List<Object> DEFAULT_ARGS = Collections.unmodifiableList(Arrays.asList("", 0, 0L, Boolean.FALSE, Float.valueOf(0.0f), 0.0, Character.valueOf(' '), (byte)-128, (short)Short.MIN_VALUE));

    public PowerTableModel(String[] headers, Class<?>[] classes) {
        if (headers.length != classes.length) {
            throw new IllegalArgumentException("Header and column array sizes differ");
        }
        this.model.setHeaders(headers);
        this.columnClasses = classes;
    }

    public PowerTableModel() {
    }

    public void setRowValues(int row, Object[] values) {
        if (values.length != this.model.getHeaderCount()) {
            throw new IllegalArgumentException("Incorrect number of data items");
        }
        this.model.setCurrentPos(row);
        for (int i = 0; i < values.length; ++i) {
            this.model.addColumnValue(this.model.getHeaders()[i], values[i]);
        }
    }

    public Data getData() {
        return this.model;
    }

    public void addNewColumn(String colName, Class<?> colClass) {
        this.model.addHeader(colName);
        Class[] newClasses = new Class[this.columnClasses.length + 1];
        System.arraycopy(this.columnClasses, 0, newClasses, 0, this.columnClasses.length);
        newClasses[newClasses.length - 1] = colClass;
        this.columnClasses = newClasses;
        Object defaultValue = this.createDefaultValue(this.columnClasses.length - 1);
        this.model.setColumnData(colName, defaultValue);
        this.fireTableStructureChanged();
    }

    @Override
    public void removeRow(int row) {
        log.debug("remove row: {}", (Object)row);
        if (this.model.size() > row) {
            log.debug("Calling remove row on Data");
            this.model.removeRow(row);
        }
    }

    public void removeColumn(int col) {
        this.model.removeColumn(col);
        this.fireTableStructureChanged();
    }

    public void setColumnData(int col, List<?> data) {
        this.model.setColumnData(col, data);
    }

    public List<?> getColumnData(String colName) {
        return this.model.getColumnAsObjectArray(colName);
    }

    public void clearData() {
        String[] headers = this.model.getHeaders();
        this.model = new Data();
        this.model.setHeaders(headers);
        this.fireTableDataChanged();
    }

    @Override
    public void addRow(Object[] data) {
        if (data.length != this.model.getHeaderCount()) {
            throw new IllegalArgumentException("Incorrect number of data items");
        }
        this.model.setCurrentPos(this.model.size());
        for (int i = 0; i < data.length; ++i) {
            this.model.addColumnValue(this.model.getHeaders()[i], data[i]);
        }
    }

    @Override
    public void moveRow(int start, int end, int to) {
        ArrayList<Object> rows = new ArrayList<Object>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            rows.add(this.getRowData(i));
        }
        ArrayList subList = new ArrayList(rows.subList(start, end));
        for (int x = end - 1; x >= start; --x) {
            rows.remove(x);
        }
        rows.addAll(to, subList);
        for (int i = 0; i < rows.size(); ++i) {
            this.setRowValues(i, (Object[])rows.get(i));
        }
        super.fireTableChanged(new TableModelEvent(this));
    }

    public void addNewRow() {
        this.addRow(this.createDefaultRow());
    }

    private Object[] createDefaultRow() {
        Object[] rowData = new Object[this.getColumnCount()];
        for (int i = 0; i < rowData.length; ++i) {
            rowData[i] = this.createDefaultValue(i);
        }
        return rowData;
    }

    public Object[] getRowData(int row) {
        Object[] rowData = new Object[this.getColumnCount()];
        Arrays.setAll(rowData, i -> this.model.getColumnValue(i, row));
        return rowData;
    }

    private Object createDefaultValue(int i) {
        Class<?> colClass = this.getColumnClass(i);
        try {
            return colClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            for (Object initArg : DEFAULT_ARGS) {
                try {
                    Constructor<?> constr = colClass.getConstructor(initArg.getClass());
                    return constr.newInstance(initArg);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                }
            }
            return "";
        }
    }

    @Override
    public int getRowCount() {
        if (this.model == null) {
            return 0;
        }
        return this.model.size();
    }

    @Override
    public int getColumnCount() {
        return this.model.getHeaders().length;
    }

    @Override
    public String getColumnName(int column) {
        return this.model.getHeaders()[column];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.columnClasses[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.model.getColumnValue(column, row);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (row < this.model.size()) {
            this.model.setCurrentPos(row);
            this.model.addColumnValue(this.model.getHeaders()[column], value);
        }
    }
}

