/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSFilenameHelper {
    private static final CSSFilenameHelper s_aInstance = new CSSFilenameHelper();

    private CSSFilenameHelper() {
    }

    public static boolean isCSSFilename(@Nullable String string) {
        return StringHelper.endsWith((String)string, (String)".css");
    }

    public static boolean isMinifiedCSSFilename(@Nullable String string) {
        return StringHelper.endsWith((String)string, (String)".min.css");
    }

    public static boolean isRegularCSSFilename(@Nullable String string) {
        return CSSFilenameHelper.isCSSFilename(string) && !CSSFilenameHelper.isMinifiedCSSFilename(string);
    }

    @Nonnull
    public static String getMinifiedCSSFilename(@Nonnull String string) {
        ValueEnforcer.isTrue((boolean)CSSFilenameHelper.isCSSFilename(string), (String)("Passed file name '" + string + "' is not a CSS file name!"));
        if (CSSFilenameHelper.isMinifiedCSSFilename(string)) {
            return string;
        }
        return StringHelper.trimEnd((String)string, (String)".css") + ".min.css";
    }
}

