/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streamprovider;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.IHasOutputStreamAndWriter;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;

public class ByteArrayOutputStreamProvider
implements IHasOutputStreamAndWriter,
Serializable {
    private final NonBlockingByteArrayOutputStream m_aOS = new NonBlockingByteArrayOutputStream();

    @Override
    @Nonnull
    public final NonBlockingByteArrayOutputStream getOutputStream(@Nonnull EAppend eAppend) {
        if (eAppend.isTruncate()) {
            this.m_aOS.reset();
        }
        return this.m_aOS;
    }

    @Override
    public final boolean isWriteMultiple() {
        return true;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final byte[] getBytes() {
        return this.m_aOS.toByteArray();
    }

    @Nonnull
    public final String getAsString(@Nonnull Charset charset) {
        return this.m_aOS.getAsString(charset);
    }

    public String toString() {
        return new ToStringGenerator(this).append("os", this.m_aOS).getToString();
    }
}

