/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.FatalDiscoveryException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.ServerVersion;

public class RoutingProcedureRunner {
    static final String ROUTING_CONTEXT = "context";
    static final String GET_ROUTING_TABLE = "CALL dbms.cluster.routing.getRoutingTable($context)";
    final RoutingContext context;

    public RoutingProcedureRunner(RoutingContext context) {
        this.context = context;
    }

    public CompletionStage<RoutingProcedureResponse> run(Connection connection, DatabaseName databaseName, Bookmark bookmark) {
        DirectConnection delegate = this.connection(connection);
        Query procedure = this.procedureQuery(connection.serverVersion(), databaseName);
        BookmarkHolder bookmarkHolder = this.bookmarkHolder(bookmark);
        return this.runProcedure(delegate, procedure, bookmarkHolder).thenCompose(records -> this.releaseConnection(delegate, (List<Record>)records)).handle((records, error) -> RoutingProcedureRunner.processProcedureResponse(procedure, records, error));
    }

    DirectConnection connection(Connection connection) {
        return new DirectConnection(connection, DatabaseNameUtil.defaultDatabase(), AccessMode.WRITE);
    }

    Query procedureQuery(ServerVersion serverVersion, DatabaseName databaseName) {
        if (databaseName.databaseName().isPresent()) {
            throw new FatalDiscoveryException(String.format("Refreshing routing table for multi-databases is not supported in server version lower than 4.0. Current server version: %s. Database name: '%s'", serverVersion, databaseName.description()));
        }
        return new Query(GET_ROUTING_TABLE, Values.parameters(ROUTING_CONTEXT, this.context.toMap()));
    }

    BookmarkHolder bookmarkHolder(Bookmark ignored) {
        return BookmarkHolder.NO_OP;
    }

    CompletionStage<List<Record>> runProcedure(Connection connection, Query procedure, BookmarkHolder bookmarkHolder) {
        return connection.protocol().runInAutoCommitTransaction(connection, procedure, bookmarkHolder, TransactionConfig.empty(), true, -1L).asyncResult().thenCompose(ResultCursor::listAsync);
    }

    private CompletionStage<List<Record>> releaseConnection(Connection connection, List<Record> records) {
        return connection.release().thenApply(ignore -> records);
    }

    private static RoutingProcedureResponse processProcedureResponse(Query procedure, List<Record> records, Throwable error) {
        Throwable cause = Futures.completionExceptionCause(error);
        if (cause != null) {
            return RoutingProcedureRunner.handleError(procedure, cause);
        }
        return new RoutingProcedureResponse(procedure, records);
    }

    private static RoutingProcedureResponse handleError(Query procedure, Throwable error) {
        if (error instanceof ClientException) {
            return new RoutingProcedureResponse(procedure, error);
        }
        throw new CompletionException(error);
    }
}

