/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.util.Alignment;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import javax.swing.Icon;

public class OverlayIcon
implements Icon {
    private Icon icon;
    private Icon overlay;
    private Alignment alignment;

    public OverlayIcon(Icon icon, Icon overlay, Alignment alignment) {
        this.setIcon(icon);
        this.setOverlay(overlay);
        this.setAlignment(alignment);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon != null ? icon : EmptyIcon.create(0);
    }

    public void setOverlay(Icon overlay) {
        this.overlay = overlay != null ? overlay : EmptyIcon.create(0);
    }

    public void setAlignment(Alignment alignment) {
        Objects.requireNonNull(alignment);
        this.alignment = alignment;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.icon.paintIcon(c, g, x, y);
        Point pos = this.alignment.alignInside(new Dimension(this.overlay.getIconWidth(), this.overlay.getIconHeight()), new Rectangle(x, y, this.getIconWidth(), this.getIconHeight()));
        this.overlay.paintIcon(c, g, pos.x, pos.y);
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }
}

