/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.curl;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jmeter.protocol.http.curl.ArgumentHolder;

public class StringArgumentHolder
implements ArgumentHolder {
    private String name;
    private Map<String, String> metadata;

    public int hashCode() {
        return Objects.hash(this.metadata, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringArgumentHolder other = (StringArgumentHolder)obj;
        return Objects.equals(this.metadata, other.metadata) && Objects.equals(this.name, other.name);
    }

    private StringArgumentHolder(String name, Map<String, String> metadata) {
        this.name = name;
        this.metadata = metadata;
    }

    public static StringArgumentHolder of(String name) {
        Pair<String, Map<String, String>> argdata = ArgumentHolder.parse(name);
        return new StringArgumentHolder((String)argdata.getLeft(), (Map)argdata.getRight());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String toString() {
        return "StringArgumentHolder(" + this.name + ", " + this.metadata + ")";
    }
}

