/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.Scale;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static BufferedImage imageFromComponent(Component c, Rectangle bounds) {
        return ImageUtil.scaledImageFromComponent(c, bounds, 1.0, 1.0, true);
    }

    public static BufferedImage imageFromComponent(Component c, Rectangle bounds, boolean print) {
        return ImageUtil.scaledImageFromComponent(c, bounds, 1.0, 1.0, print);
    }

    public static BufferedImage scaledImageFromComponent(Component c, Rectangle bounds) {
        GraphicsConfiguration gc = c.getGraphicsConfiguration();
        return ImageUtil.scaledImageFromComponent(c, bounds, Scale.getScaleX(gc), Scale.getScaleY(gc), true);
    }

    public static BufferedImage scaledImageFromComponent(Component c, Rectangle bounds, double scalex, double scaley, boolean print) {
        boolean scale = scalex != 1.0 || scaley != 1.0;
        BufferedImage image = scale ? ImageUtil.createCompatibleTransparentImage((int)(scalex * (double)bounds.width), (int)(scaley * (double)bounds.height)) : ImageUtil.createCompatibleTransparentImage(bounds.width, bounds.height);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        if (scale) {
            g2d.scale(scalex, scaley);
        }
        g2d.translate(-bounds.x, -bounds.y);
        if (print) {
            c.print(g2d);
        } else {
            c.paint(g2d);
        }
        g2d.dispose();
        return image;
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return ImageUtil.isHeadless() ? new BufferedImage(width, height, 1) : ImageUtil.getGraphicsConfiguration().createCompatibleImage(width, height, 1);
    }

    public static BufferedImage createCompatibleTransparentImage(int width, int height) {
        return ImageUtil.isHeadless() ? new BufferedImage(width, height, 2) : ImageUtil.getGraphicsConfiguration().createCompatibleImage(width, height, 2);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return ImageUtil.isHeadless() ? new BufferedImage(width, height, 2) : ImageUtil.getGraphicsConfiguration().createCompatibleImage(width, height, 3);
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }
}

