/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;

public class AntialiasingImageFilter
extends RGBImageFilter {
    private final BufferedImage destImg;
    private final int destPosX;
    private final int destPosY;
    private final int bgRgb;
    private final int bgRed;
    private final int bgGreen;
    private final int bgBlue;
    private final int fgRed;
    private final int fgGreen;
    private final int fgBlue;

    public AntialiasingImageFilter(BufferedImage destImg, int destPosX, int destPosY, Color fg, Color bg) {
        this.destImg = destImg;
        this.destPosX = destPosX;
        this.destPosY = destPosY;
        this.bgRgb = bg.getRGB();
        this.bgRed = bg.getRed();
        this.bgBlue = bg.getBlue();
        this.bgGreen = bg.getGreen();
        this.fgRed = fg.getRed();
        this.fgBlue = fg.getBlue();
        this.fgGreen = fg.getGreen();
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        if (rgb == this.bgRgb) {
            return 0;
        }
        int red = (rgb & 0xFF0000) >> 16;
        int green = (rgb & 0xFF00) >> 8;
        int blue = rgb & 0xFF;
        float aa = (float)(red - this.bgRed) / (float)(this.fgRed - this.bgRed);
        float ba = (float)(blue - this.bgBlue) / (float)(this.fgBlue - this.bgBlue);
        float ga = (float)(green - this.bgGreen) / (float)(this.fgGreen - this.bgGreen);
        if (this.destImg != null) {
            int destRgb = this.destImg.getRGB(this.destPosX + x, this.destPosY + y);
            int destRed = (destRgb & 0xFF0000) >> 16;
            int destGreen = (destRgb & 0xFF00) >> 8;
            int destBlue = destRgb & 0xFF;
            int outRed = Math.max(0, Math.min(255, (int)((float)this.fgRed * aa + (1.0f - aa) * (float)destRed)));
            int outBlue = Math.max(0, Math.min(255, (int)((float)this.fgBlue * ba + (1.0f - ba) * (float)destBlue)));
            int outGreen = Math.max(0, Math.min(255, (int)((float)this.fgGreen * ga + (1.0f - ga) * (float)destGreen)));
            return 0xFF000000 | outRed << 16 | outGreen << 8 | outBlue;
        }
        return (int)(255.0f * ((aa + ga + ba) / 3.0f)) << 24 | this.fgRed << 16 | this.fgGreen << 8 | this.fgBlue;
    }
}

