/*
 * (C) Copyright IBM Corp. 2001
 */
//$Id: OPT_LiveSetEnumerator.java,v 1.7 2002/08/23 11:29:57 dgrove-oss Exp $
package com.ibm.JikesRVM.opt;

import  java.util.Enumeration;
import  java.util.NoSuchElementException;

/**
 * An enumeration over live set lists
 *
 * @author Michael Hind
 */
public class OPT_LiveSetEnumerator implements Enumeration {

  /**
   *  the current element on this list
   */
  private OPT_LiveSetElement current;

  /**
   * The constructor
   * @param   OPT_LiveSetElement list
   */
  public OPT_LiveSetEnumerator(OPT_LiveSetElement list) {
    current = list;
  }

  /**
   * Are there any more elements?
   * @return whether there are any more elements?
   */
  public boolean hasMoreElements() {
    return  current != null;
  }

  /**
   * Returns the next element, if one exists, otherwise throws an exception
   * @return the next element, if one exists, otherwise throws an exception
   */
  public Object nextElement() {
    if (current != null) {
      OPT_LiveSetElement ret = current;
      current = current.getNext();
      return  ret.getRegisterOperand();
    } 
    else {
      throw  new NoSuchElementException("OPT_LiveSetEnumerator");
    }
  }
}



