/*
 * (C) Copyright IBM Corp. 2002
 */
//$Id: syswrap.h,v 1.5 2004/06/16 12:35:58 augart-oss Exp $

// @author David Hovemeyer

// Wrapper functions for blocking system calls,
// and accessors for the real libc system call functions.

#ifndef SYSWRAP_H
#define SYSWRAP_H

#include <sys/time.h>
#include <sys/types.h>
#if !defined(RVM_FOR_SINGLE_VIRTUAL_PROCESSOR)
# include <pthread.h>
#endif

/* Patterns for Functions from the C library. */
typedef int (*SelectFunc_t)(int, fd_set*, fd_set*, fd_set*, struct timeval*);
typedef int (*PollFunc_t)(struct pollfd*, long unsigned int, int);

// Init function for the syscall wrapper library.
#if defined(RVM_FOR_SINGLE_VIRTUAL_PROCESSOR)
extern "C" void initSyscallWrapperLibrary(void *jtoc, int processorsOffset,
  int vmProcessorId);
#else
extern "C" void initSyscallWrapperLibrary(void *jtoc, int processorsOffset);
#endif

// Accessor for real (libc) system call functions;
// allows bypassing our wrapper functions.
extern "C" SelectFunc_t getLibcSelect(void);

#endif // SYSWRAP_H
