/* ===========================================================
 * JFreeChart : a free chart library for the Java(tm) platform
 * ===========================================================
 *
 * (C) Copyright 2000-2005, by Object Refinery Limited and Contributors.
 *
 * Project Info:  http://www.jfree.org/jfreechart/index.html
 *
 * This library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by 
 * the Free Software Foundation; either version 2.1 of the License, or 
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc. 
 * in the United States and other countries.]
 *
 * ---------------
 * LabelBlock.java
 * ---------------
 * (C) Copyright 2004, 2005, by Object Refinery Limited.
 *
 * Original Author:  David Gilbert (for Object Refinery Limited);
 * Contributor(s):   -;
 *
 * $Id: LabelBlock.java,v 1.3 2005/02/13 22:15:08 mungady Exp $
 *
 * Changes:
 * --------
 * 22-Oct-2004 : Version 1 (DG);
 * 
 */

package org.jfree.chart.block;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Size2D;

/**
 * A block containing a label.
 */
public class LabelBlock extends AbstractBlock implements Block {
    
    private TextBlock label;
    
    private Font font;
    
    /**
     * Creates a new label block.
     * 
     * @param label  the label.
     */
    public LabelBlock(String label) {
        this(label, new Font("Bitstream Vera Sans", Font.PLAIN, 11));
    }
    
    /**
     * Creates a new label block.
     * 
     * @param label  the label.
     * @param font  the font.
     */
    public LabelBlock(String label, Font font) {        
        this.label = TextUtilities.createTextBlock(label, font, Color.black);
        this.font = font;
    }
    
    /**
     * Arranges the contents of the block, within the given constraints, and 
     * returns the block size.
     * 
     * @param g2  the graphics device.
     * @param constraint  the constraint (<code>null</code> not permitted).
     * 
     * @return The block size (in Java2D units, never <code>null</code>).
     */
    public Size2D arrange(Graphics2D g2, RectangleConstraint constraint) {
        g2.setFont(this.font);
        //Rectangle2D r = TextUtilities.getTextBounds(this.label, g2, g2.getFontMetrics());
        Size2D s = this.label.calculateDimensions(g2);
        return s;
    }
    
    /**
     * Draws the block.
     * 
     * @param g2  the graphics device.
     * @param area  the area.
     */
    public void draw(Graphics2D g2, Rectangle2D area) {
        g2.setPaint(Color.black);
        g2.setFont(this.font);
        this.label.draw(
            g2, (float) area.getX(), (float) area.getY(), 
            TextBlockAnchor.TOP_LEFT
        );
    }

}
