/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import org.jfree.data.DefaultKeyedValues2D;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.IntervalXYDelegate;
import org.jfree.data.xy.TableXYDataset;

public class CategoryTableXYDataset
extends AbstractIntervalXYDataset
implements TableXYDataset,
IntervalXYDataset,
DomainInfo {
    private DefaultKeyedValues2D values = new DefaultKeyedValues2D(true);
    private IntervalXYDelegate intervalDelegate = new IntervalXYDelegate(this);

    public void add(double x, double y, String seriesName) {
        this.add(new Double(x), new Double(y), seriesName, true);
    }

    public void add(Number x, Number y, String seriesName, boolean notify) {
        this.values.addValue(y, (Comparable)((Object)x), (Comparable)((Object)seriesName));
        int series = this.values.getColumnIndex((Comparable)((Object)seriesName));
        int item = this.values.getRowIndex((Comparable)((Object)x));
        this.intervalDelegate.itemAdded(series, item);
        if (notify) {
            this.fireDatasetChanged();
        }
    }

    public void remove(double x, String seriesName) {
        this.remove(new Double(x), seriesName, true);
    }

    public void remove(Number x, String seriesName, boolean notify) {
        this.values.removeValue((Comparable)((Object)x), (Comparable)((Object)seriesName));
        this.intervalDelegate.itemRemoved(x.doubleValue());
        if (notify) {
            this.fireDatasetChanged();
        }
    }

    public int getSeriesCount() {
        return this.values.getColumnCount();
    }

    public String getSeriesName(int series) {
        return this.values.getColumnKey(series).toString();
    }

    public int getItemCount() {
        return this.values.getRowCount();
    }

    public int getItemCount(int series) {
        return this.getItemCount();
    }

    public Number getX(int series, int item) {
        return (Number)((Object)this.values.getRowKey(item));
    }

    public Number getStartX(int series, int item) {
        return this.intervalDelegate.getStartX(series, item);
    }

    public Number getEndX(int series, int item) {
        return this.intervalDelegate.getEndX(series, item);
    }

    public Number getY(int series, int item) {
        return this.values.getValue(item, series);
    }

    public Number getStartY(int series, int item) {
        return this.getY(series, item);
    }

    public Number getEndY(int series, int item) {
        return this.getY(series, item);
    }

    public double getDomainLowerBound(boolean includeInterval) {
        return this.intervalDelegate.getDomainLowerBound(includeInterval);
    }

    public double getDomainUpperBound(boolean includeInterval) {
        return this.intervalDelegate.getDomainUpperBound(includeInterval);
    }

    public Range getDomainBounds(boolean includeInterval) {
        return this.intervalDelegate.getDomainBounds(includeInterval);
    }

    public double getIntervalPositionFactor() {
        return this.intervalDelegate.getIntervalPositionFactor();
    }

    public void setIntervalPositionFactor(double d) {
        this.intervalDelegate.setIntervalPositionFactor(d);
        this.fireDatasetChanged();
    }

    public double getIntervalWidth() {
        return this.intervalDelegate.getIntervalWidth();
    }

    public void setIntervalWidth(double d) {
        this.intervalDelegate.setIntervalWidth(d);
        this.fireDatasetChanged();
    }

    public boolean isAutoWidth() {
        return this.intervalDelegate.isAutoWidth();
    }

    public void setAutoWidth(boolean b) {
        this.intervalDelegate.setAutoWidth(b);
        this.fireDatasetChanged();
    }
}

