/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class MemoryUsageDemo
extends JPanel {
    private TimeSeries total = new TimeSeries("Total Memory", class$org$jfree$data$time$Millisecond == null ? (class$org$jfree$data$time$Millisecond = MemoryUsageDemo.class$("org.jfree.data.time.Millisecond")) : class$org$jfree$data$time$Millisecond);
    private TimeSeries free;
    static /* synthetic */ Class class$org$jfree$data$time$Millisecond;

    public MemoryUsageDemo(int n) {
        super(new BorderLayout());
        this.total.setHistoryCount(n);
        this.free = new TimeSeries("Free Memory", class$org$jfree$data$time$Millisecond == null ? (class$org$jfree$data$time$Millisecond = MemoryUsageDemo.class$("org.jfree.data.time.Millisecond")) : class$org$jfree$data$time$Millisecond);
        this.free.setHistoryCount(n);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(this.total);
        timeSeriesCollection.addSeries(this.free);
        DateAxis dateAxis = new DateAxis("Time");
        NumberAxis numberAxis = new NumberAxis("Memory");
        dateAxis.setTickLabelFont(new Font("SansSerif", 0, 12));
        numberAxis.setTickLabelFont(new Font("SansSerif", 0, 12));
        dateAxis.setLabelFont(new Font("SansSerif", 0, 14));
        numberAxis.setLabelFont(new Font("SansSerif", 0, 14));
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
        xYLineAndShapeRenderer.setSeriesPaint(0, (Paint)Color.red);
        xYLineAndShapeRenderer.setSeriesPaint(1, (Paint)Color.green);
        xYLineAndShapeRenderer.setStroke((Stroke)new BasicStroke(3.0f, 0, 2));
        XYPlot xYPlot = new XYPlot((XYDataset)timeSeriesCollection, (ValueAxis)dateAxis, (ValueAxis)numberAxis, (XYItemRenderer)xYLineAndShapeRenderer);
        xYPlot.setBackgroundPaint((Paint)Color.lightGray);
        xYPlot.setDomainGridlinePaint((Paint)Color.white);
        xYPlot.setRangeGridlinePaint((Paint)Color.white);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        dateAxis.setAutoRange(true);
        dateAxis.setLowerMargin(0.0);
        dateAxis.setUpperMargin(0.0);
        dateAxis.setTickLabelsVisible(true);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        JFreeChart jFreeChart = new JFreeChart("JVM Memory Usage", new Font("SansSerif", 1, 24), (Plot)xYPlot, true);
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.black)));
        this.add((Component)chartPanel);
    }

    private void addTotalObservation(double d) {
        this.total.add((RegularTimePeriod)new Millisecond(), d);
    }

    private void addFreeObservation(double d) {
        this.free.add((RegularTimePeriod)new Millisecond(), d);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Memory Usage Demo");
        MemoryUsageDemo memoryUsageDemo = new MemoryUsageDemo(30000);
        jFrame.getContentPane().add((Component)memoryUsageDemo, "Center");
        jFrame.setBounds(200, 120, 600, 280);
        jFrame.setVisible(true);
        MemoryUsageDemo memoryUsageDemo2 = memoryUsageDemo;
        memoryUsageDemo2.getClass();
        memoryUsageDemo2.new DataGenerator(100).start();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DataGenerator
    extends Timer
    implements ActionListener {
        DataGenerator(int n) {
            super(n, null);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l = Runtime.getRuntime().freeMemory();
            long l2 = Runtime.getRuntime().totalMemory();
            MemoryUsageDemo.this.addTotalObservation(l2);
            MemoryUsageDemo.this.addFreeObservation(l);
        }
    }
}

