/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.VerticalAlignment;
import org.jfree.util.UnitType;

public class ImageMapDemo5 {
    public void saveImageAndHTML() {
        double[][] dArrayArray = new double[][]{{56.0, -12.0, 34.0, 76.0, 56.0, 100.0, 67.0, 45.0}, {37.0, 45.0, 67.0, 25.0, 34.0, 34.0, 100.0, 53.0}, {43.0, 54.0, 34.0, 34.0, 87.0, 64.0, 73.0, 12.0}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset((String)"Series ", (String)"Type ", (double[][])dArrayArray);
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        try {
            ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            File file = new File("areachart100.png");
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)600, (int)400, (ChartRenderingInfo)chartRenderingInfo);
            File file2 = new File("areachart100.html");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
            printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
            printWriter.println("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            printWriter.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">");
            printWriter.println("<head><title>JFreeChart Image Map Demo</title></head>");
            printWriter.println("<body><p>");
            ImageMapUtilities.writeImageMap((PrintWriter)printWriter, (String)"chart", (ChartRenderingInfo)chartRenderingInfo);
            printWriter.println("<img src=\"areachart100.png\" width=\"600\" height=\"400\" usemap=\"#chart\" alt=\"areachart100.png\"/>");
            printWriter.println("</p></body>");
            printWriter.println("</html>");
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createAreaChart((String)"Area Chart", (String)"Category", (String)"Value", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        TextTitle textTitle = new TextTitle("An area chart demonstration.  We use this subtitle  as an example of what happens when you get a really long title or subtitle.");
        textTitle.setFont(new Font("SansSerif", 0, 12));
        textTitle.setPosition(RectangleEdge.TOP);
        textTitle.setPadding(new RectangleInsets(UnitType.RELATIVE, 0.05, 0.05, 0.05, 0.05));
        textTitle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        jFreeChart.addSubtitle((Title)textTitle);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setForegroundAlpha(0.5f);
        categoryPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        categoryPlot.setBackgroundPaint((Paint)Color.lightGray);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setDomainGridlinePaint((Paint)Color.white);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint((Paint)Color.white);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        categoryAxis.setLowerMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setLabelAngle(0.0);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        ImageMapDemo5 imageMapDemo5 = new ImageMapDemo5();
        imageMapDemo5.saveImageAndHTML();
    }
}

