/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.text.DateFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.time.Day;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class EventFrequencyDemo1
extends ApplicationFrame {
    public EventFrequencyDemo1(String string) {
        super(string);
        CategoryDataset categoryDataset = EventFrequencyDemo1.createDataset();
        JFreeChart jFreeChart = EventFrequencyDemo1.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartPanel);
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart((String)"Event Frequency Demo", (String)"Category", (String)"Value", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)new Color(255, 255, 204));
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.getDomainAxis().setMaximumCategoryLabelWidthRatio(10.0f);
        categoryPlot.setRangeAxis((ValueAxis)new DateAxis("Date"));
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator("", DateFormat.getDateInstance());
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer(false, true);
        lineAndShapeRenderer.setToolTipGenerator((CategoryToolTipGenerator)standardCategoryToolTipGenerator);
        categoryPlot.setRenderer((CategoryItemRenderer)lineAndShapeRenderer);
        return jFreeChart;
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        Day day = new Day(12, 6, 2002);
        Day day2 = new Day(14, 6, 2002);
        Day day3 = new Day(15, 6, 2002);
        Day day4 = new Day(10, 7, 2002);
        Day day5 = new Day(20, 7, 2002);
        Day day6 = new Day(22, 8, 2002);
        defaultCategoryDataset.setValue((Number)new Long(day.getMiddleMillisecond()), (Comparable)((Object)"Series 1"), (Comparable)((Object)"Requirement 1"));
        defaultCategoryDataset.setValue((Number)new Long(day.getMiddleMillisecond()), (Comparable)((Object)"Series 1"), (Comparable)((Object)"Requirement 2"));
        defaultCategoryDataset.setValue((Number)new Long(day2.getMiddleMillisecond()), (Comparable)((Object)"Series 1"), (Comparable)((Object)"Requirement 3"));
        defaultCategoryDataset.setValue((Number)new Long(day3.getMiddleMillisecond()), (Comparable)((Object)"Series 2"), (Comparable)((Object)"Requirement 1"));
        defaultCategoryDataset.setValue((Number)new Long(day4.getMiddleMillisecond()), (Comparable)((Object)"Series 2"), (Comparable)((Object)"Requirement 3"));
        defaultCategoryDataset.setValue((Number)new Long(day5.getMiddleMillisecond()), (Comparable)((Object)"Series 3"), (Comparable)((Object)"Requirement 2"));
        defaultCategoryDataset.setValue((Number)new Long(day6.getMiddleMillisecond()), (Comparable)((Object)"Series 1"), (Comparable)((Object)"Requirement 4"));
        return defaultCategoryDataset;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = EventFrequencyDemo1.createChart(EventFrequencyDemo1.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        EventFrequencyDemo1 eventFrequencyDemo1 = new EventFrequencyDemo1("Event Frequency Demo");
        eventFrequencyDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)eventFrequencyDemo1));
        eventFrequencyDemo1.setVisible(true);
    }
}

