/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.bootstrap;

import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.objectweb.carol.util.bootstrap.ProcessesManager;

public class ProcessesDaemon {
    private static Options cmdLineOptions = null;
    private static Registry registry = null;
    public static int RJVM_PORT_NUMBER = 9090;
    public static boolean CLEAN_JVM_PROCESSES = true;

    public static void printHelp(Options cmdLineOptions) {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp("RJVM Daemon [options...]", cmdLineOptions);
    }

    public static void main(String[] args) {
        cmdLineOptions = new Options();
        cmdLineOptions.addOption('c', "clean", false, "clean jvm hashtables mode", false, false);
        cmdLineOptions.addOption('p', "port", true, "daemon rmi port number", false, false);
        cmdLineOptions.addOption('h', "help", false, "print this message and exit", false, false);
        cmdLineOptions.addOption('v', "verbose", false, "verbose mode", false, false);
        CommandLine cmd = null;
        try {
            cmd = cmdLineOptions.parse(args, true);
        }
        catch (ParseException e) {
            System.err.println("\n" + e.getMessage());
            ProcessesDaemon.printHelp(cmdLineOptions);
            System.err.println();
            System.exit(1);
        }
        boolean verbose = cmd.hasOption('v');
        if (cmd.hasOption('h')) {
            ProcessesDaemon.printHelp(cmdLineOptions);
            System.exit(1);
        }
        if (cmd.hasOption('c')) {
            CLEAN_JVM_PROCESSES = cmd.hasOption('c');
        }
        if (cmd.hasOption('p')) {
            RJVM_PORT_NUMBER = new Integer(cmd.getOptionValue('p'));
        }
        try {
            ProcessesManager pmanager = new ProcessesManager(CLEAN_JVM_PROCESSES, verbose);
            PortableRemoteObject.exportObject((Remote)pmanager);
            registry = LocateRegistry.createRegistry(RJVM_PORT_NUMBER);
            registry.bind("proc", pmanager);
        }
        catch (Exception e) {
            System.err.println("Can not start remote daemon " + e);
        }
        System.out.println("Daemon server started on port: " + RJVM_PORT_NUMBER);
    }
}

