PAP=examples/papers
T=examples/tmp
FT=examples/features
HNS=examples/harness

GCC="gcc -I examples -I examples/features -o $T/out.o -c"
J2C="./jekyll --j2c -I examples -I examples/features -I examples/tmp"
C2J="./jekyll --c2j -I examples -I examples/features -I examples/tmp"

cp $PAP/prelude.jkl $PAP/dr_jekyll_examples.jkl $PAP/dr_jekyll_examples_mod.c $T
cp $HNS/odds.jkl $T
cp $FT/generics.jkh $FT/generics.jkl $FT/show.jkh $FT/show.jkl $T
cp $FT/lambda.jkl $T

echo "prelude"
$J2C $T/prelude.jkl --new
$C2J $T/prelude.c --copy
diff $T/prelude.jkl $T/prelude2.jkl
$GCC $T/prelude.c

echo "dr jekyll examples"
$J2C $T/dr_jekyll_examples.jkl --new
$C2J $T/dr_jekyll_examples.c --copy
diff $T/dr_jekyll_examples.jkl $T/dr_jekyll_examples2.jkl
$GCC $T/dr_jekyll_examples.c 

echo "back conversion"
$C2J $T/dr_jekyll_examples_mod.c -p $T/dr_jekyll_examples.jkl
$J2C $T/dr_jekyll_examples_mod.jkl -p $T/dr_jekyll_examples_mod.c --copy
diff $T/dr_jekyll_examples_mod.c $T/dr_jekyll_examples_mod2.c

echo "odds"
$J2C $T/odds.jkl --new
$C2J $T/odds.c --copy
diff $T/odds.jkl $T/odds2.jkl
$GCC $T/odds.c

echo "generics - h"
$J2C $T/generics.jkh --new 
$C2J $T/generics.h --copy  
diff $T/generics.jkh $T/generics2.jkh

echo "generics - c"
$J2C $T/generics.jkl --new
$C2J $T/generics.c --copy
diff $T/generics.jkl $T/generics2.jkl
$GCC $T/generics.c 

echo "lambda"
$J2C $T/lambda.jkl --new  
$C2J $T/lambda.c --copy
diff $T/lambda.jkl $T/lambda2.jkl
$GCC $T/lambda.c

echo "show - h"
$J2C $T/show.jkh --new
$C2J $T/show.h --copy
diff $T/show.jkh $T/show2.jkh

echo "show - c"
$J2C $T/show.jkl --new
$C2J $T/show.c --copy
diff $T/show.jkl $T/show2.jkl
$GCC $T/show.c

