
open Syntax
open Location
open Lexing

(* ------------------------------------------------------------
 * Construct Metadata
 * ------------------------------------------------------------ *)

val mk : position -> position -> metadata
val mkm : unit -> metadata
val ident : lextoken * string -> id


(* ------------------------------------------------------------
 * Construct operator application expressions
 * ------------------------------------------------------------ *)

val binop : expression -> string -> expression -> expression
val unop : string -> expression -> expression
val punop : expression -> string -> expression


(* ------------------------------------------------------------
 * Keep track of which names are types, constructors, etc
 * ------------------------------------------------------------ *)

val add_typename : string -> unit
val add_tyvar : string -> unit
val add_define : string -> defdetails -> unit
val add_constructor : string -> unit
val add_struct : string -> unit
val add_method : string -> unit

val is_typename : string -> bool
val is_tyvar : string -> bool
val is_define : string -> bool
val is_constructor : string -> bool
val is_struct : string -> bool
val is_method : string -> bool
val is_silentmacro : string -> bool

val add_macrotype : string -> id list -> extdecl

val register_connames : coretyp -> unit

val reset_lexnames : unit -> unit


(* ------------------------------------------------------------
 * Util functions needed for Jekyll parsing
 * ------------------------------------------------------------ *)

val set_fundecl_kinds : funkind -> declaration list -> declaration list

(* ------------------------------------------------------------
 * Parse C types, separating type specifiers from qualifiers
 * ------------------------------------------------------------ *)

type spec_or_ty = 
	| OSpec of specqual
 	| OType of coretyp
	
val specs_to_basetyp : spec_or_ty list -> basetyp
val specs_to_typ : spec_or_ty list -> typ	
val make_typ : spec_or_ty list -> declmod list -> typ
val mkdecl : spec_or_ty list -> declarator -> declaration

val process_funargs : declaration list -> declaration list


(* ------------------------------------------------------------
 * Warn if we are in Jekyll (don't warn about C headers)
 * ------------------------------------------------------------ *)

val warn_bad_jekyll : string -> unit


(* ------------------------------------------------------------
 * What language are we parsing
 * ------------------------------------------------------------ *)

val get_current_lang : unit -> lang
val set_current_file : string -> unit

val file_is_jekyll_c : string -> bool


(* ------------------------------------------------------------
 * Unix vs DOS line endings
 * ------------------------------------------------------------ *)

val file_is_dos : string -> bool

(* ------------------------------------------------------------
 * Parse Errors
 * ------------------------------------------------------------ *)

val parse_error : 'a -> 'b


(* ------------------------------------------------------------
 * Find #includes in a file
 * ------------------------------------------------------------ *)

val find_includes : string -> string list
val process_includes : string list -> string list
val process_include : string -> string
val process_c_include : string -> string
val scan_line_for_include : string -> string option


