#include <jekyll_1.h>

unsafe macrotype( void* NULL);

enum bool{TRUE = -1, FALSE = 0};

typedef struct List List;
typedef struct Node Node;

struct Node{ 
    void *element;
    List *tail; 	
};

/* a list of elements of type %a% */
struct List{
    enum{NODE, EMPTY} _tag; union { 
    Node NODE;
} _body;     /* an empty list */
};

/* map a function over a list */
List *listmap(List* c, void *f(void* _env,void *x), void* _fe_f){
    switch((*c)._tag){
        List *node;
        List *empty;
        Node n; 
        case EMPTY:
        empty =(List *) GC_malloc (sizeof(List ));
        empty->_tag= EMPTY; return empty; 
        case NODE : n =(*c)._body.NODE;
                 node =(List *) GC_malloc (sizeof(List ));
                 node->_tag= NODE;
                 node->_body.NODE.element = 
                 f(_fe_f,n.element);
                 node->_body.NODE.tail =
  	     	 listmap(n.tail,f,_fe_f); 
            return node;
    }
}

/* can be mapped over */
struct Mappable{ 
    void * (*map)(void* _env,void *c, void *f(void* _env,void *x), void* _fe_f); 
};

extern struct Mappable _dmMappable_List;
    struct List * List_map(void* _env, struct List *c, void *f(void* _env, void *x), void* _fe_f);

/* we can map over lists */
struct Mappable _dmMappable_List = {
    (void*)&List_map
    };
    List *List_map(void* _env,List* c, void *f(void* _env,void *x), void* _fe_f){
        return listmap(c,f,_fe_f);
    }

/* supports basic numerical operations */
struct Num{ 
    void* (* plus)(void* _env,void* x, void* y);
    void* (* fromInt)(void* _env,int x);
};

extern struct Num _dmNum_int;
    int * int_plus(void* _env, int *x, int *y);
    int * int_fromInt(void* _env, int x);

/* ints support basic numerical operations */
struct Num _dmNum_int = {
    (void*)&int_plus, (void*)&int_fromInt
    };
    int* int_plus(void* _env,int* x, int* y){
        int *_tmp0;
        _tmp0 =(int *) GC_malloc (sizeof(int ));
        *_tmp0 = *x + *y;return _tmp0;}
    int* int_fromInt(void* _env,int x){
        int *_tmp0;
        _tmp0 =(int *) GC_malloc (sizeof(int ));
        *_tmp0 = x;return _tmp0;}

void* plusint(struct Num* _dmNum_a , void* _deNum_a,void *x,int y){
    return _dmNum_a-> plus(_deNum_a,x,_dmNum_a->fromInt(_deNum_a,y));
}
int *_ff_all_plus20(void* _env,int* x){ /* hello */ ret plusint(&_dmNum_int,_DNULL,x,2);}

/* demonstrate lambda expressions */
List* all_plus2(List* l){
    return List_map(_DNULL,l, (void*) &_ff_all_plus20, _DNULL);
}
