
open Location
open Prettyutil


(* ------------------------------------------------------------
 * Errors, warnings, and messages
 * ------------------------------------------------------------ *)

val warning : span -> string -> unit
val error : span -> string -> unit
val fatal : span -> string -> 'a
val intwarn : string -> unit
val intfatal : string -> 'a
val msg : string -> unit


(* ------------------------------------------------------------
 * Create custom errors and warnings
 * ------------------------------------------------------------ *)

val print_simple_error : string -> span -> unit
val print_span_msg : span -> string -> unit
val print_span_source : span -> unit
val print_span_guide : span -> unit
val print_error_header : string -> span -> unit
val print_error_trailer : unit -> unit



(* ------------------------------------------------------------
 * Avoid generating errors while processing another error
 * ------------------------------------------------------------ *)

val with_suspend_errors : (unit -> 'a) -> 'a 
