/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.formatter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StatefulWriter;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.io.xml.Dom4JDriver;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sciplore.formatter.BeanConverter;
import org.sciplore.formatter.BeanJSONConverter;
import org.sciplore.formatter.CollectionBean;
import org.sciplore.formatter.SciploreXMLWriter;

public abstract class Bean {
    private List<String> activeElements = new ArrayList<String>();

    public String toXML() {
        XStream xstream = this.getXMLXstream();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        return String.valueOf(xml) + xstream.toXML((Object)this);
    }

    public OutputStream toXMLStream(OutputStream stream) {
        XStream xstream = this.getXMLXstream();
        try {
            stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        xstream.toXML((Object)this, stream);
        return stream;
    }

    public String toJson() {
        XStream xstream = this.getJsonXstream();
        return xstream.toXML((Object)this);
    }

    public OutputStream toJsonStream(OutputStream stream) {
        XStream xstream = this.getJsonXstream();
        xstream.toXML((Object)this, stream);
        return stream;
    }

    private XStream getXMLXstream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new Dom4JDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                SciploreXMLWriter ppw = new SciploreXMLWriter(out);
                return ppw;
            }
        });
        xstream.alias(this.getClass().getSimpleName().toLowerCase(), this.getClass());
        xstream.registerConverter((Converter)new BeanConverter(xstream.getMapper()));
        return xstream;
    }

    private XStream getJsonXstream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver(){

            public HierarchicalStreamWriter createWriter(Writer writer) {
                return new JsonWriter(writer, 1);
            }
        }){

            public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer, String rootNodeName) throws IOException {
                final StatefulWriter statefulWriter = new StatefulWriter(writer);
                return new CustomObjectOutputStream(new CustomObjectOutputStream.StreamCallback(){

                    public void writeToStream(Object object) {
                        System.out.println("marshal object: " + object);
                        this.marshal(object, (HierarchicalStreamWriter)statefulWriter);
                    }

                    public void writeFieldsToStream(Map fields) throws NotActiveException {
                        throw new NotActiveException("not in call to writeObject");
                    }

                    public void defaultWriteObject() throws NotActiveException {
                        throw new NotActiveException("not in call to writeObject");
                    }

                    public void flush() {
                        statefulWriter.flush();
                    }

                    public void close() {
                        if (statefulWriter.state() != StatefulWriter.STATE_CLOSED) {
                            statefulWriter.close();
                        }
                    }
                });
            }
        };
        xstream.alias(this.getClass().getSimpleName().toLowerCase(), this.getClass());
        xstream.registerConverter((Converter)new BeanJSONConverter(xstream.getMapper(), xstream));
        xstream.addImplicitCollection(CollectionBean.class, "collection");
        return xstream;
    }

    public String getBeanName() {
        return this.getClass().getSimpleName();
    }

    public void addActiveElement(Bean bean) {
        if (bean == null) {
            return;
        }
        Method[] methodArray = this.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("set") || m.getName().startsWith("add")) {
                try {
                    String name;
                    if (m.getName().startsWith("set") && (name = m.getName().toLowerCase().substring(3)).equalsIgnoreCase(bean.getClass().getSimpleName())) {
                        m.invoke((Object)this, bean);
                        this.activateElement(bean.getClass().getSimpleName());
                    }
                    if (m.getName().startsWith("add") && (name = m.getName().toLowerCase().substring(3)).equalsIgnoreCase(String.valueOf(bean.getClass().getSimpleName()) + "s")) {
                        m.invoke((Object)this, bean);
                        this.activateElement(String.valueOf(bean.getClass().getSimpleName()) + "s");
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public void addActiveAttribute(String elementName, String value) {
        Method[] methodArray = this.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("set")) {
                try {
                    String name = m.getName().toLowerCase().substring(3);
                    if (name.equalsIgnoreCase(elementName)) {
                        m.invoke((Object)this, value);
                        this.activateElement(elementName);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public void setElementActive(Class<Bean> clazz) {
        Method[] methodArray = this.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("set") || m.getName().startsWith("add")) {
                String name;
                if (m.getName().startsWith("set") && (name = m.getName().toLowerCase().substring(3)).equalsIgnoreCase(clazz.getSimpleName())) {
                    this.activateElement(clazz.getSimpleName());
                }
                if (m.getName().startsWith("add") && (name = m.getName().toLowerCase().substring(3)).equalsIgnoreCase(String.valueOf(clazz.getSimpleName()) + "s")) {
                    this.activateElement(String.valueOf(clazz.getSimpleName()) + "s");
                }
            }
            ++n2;
        }
    }

    public void setAttributeActive(String elementName) {
        Method[] methodArray = this.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Method m = methodArray[n2];
            if ((m.getName().startsWith("set") || m.getName().startsWith("add")) && (name = m.getName().toLowerCase().substring(3)).equalsIgnoreCase(elementName)) {
                this.activateElement(elementName);
            }
            ++n2;
        }
    }

    public void setAllElementsActive() {
        Method[] methodArray = this.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("set") || m.getName().startsWith("add")) {
                String name = m.getName().toLowerCase().substring(3);
                this.activateElement(name.toLowerCase());
            }
            ++n2;
        }
    }

    protected void activateElement(String elementName) {
        if (!this.activeElements.contains(elementName = elementName.toLowerCase())) {
            this.activeElements.add(elementName);
        }
    }

    public List<String> getActiveElements() {
        return this.activeElements;
    }
}

