// This file is auto-generated header by tools/generate-subtag.py.
// So do not edit this file.
#ifndef IV_I18N_LANGUAGE_TAG_H_
#define IV_I18N_LANGUAGE_TAG_H_
#include <iv/detail/unordered_map.h>
#include <iv/detail/array.h>
#include <iv/string_view.h>
namespace iv {
namespace core {
namespace i18n {
namespace data {

// Irregular / regular grandfathered language tags and Preferred-Value.
// Following tags don't provide Preferred-Value in registry.
// So we define fallback tags by executing ICU canonicalizations.
//     cel-graulish cel-graulis
//     en-GB-oed    en-GB-x-oed
//     i-default    en-x-i-default
//     i-enochian   x-i-enochian
//     i-mingo      see-x-i-mingo
//     zh-min       nan-x-zh-min
typedef std::array<std::pair<string_view, string_view>, 26> GrandfatheredArray;
static const GrandfatheredArray kGrandfathered = { {
  std::make_pair("cel-graulish", "cel-graulis"),
  std::make_pair("en-gb-oed", "en-GB-x-oed"),
  std::make_pair("i-default", "en-x-i-default"),
  std::make_pair("i-enochian", "x-i-enochian"),
  std::make_pair("i-mingo", "see-x-i-mingo"),
  std::make_pair("zh-min", "nan-x-zh-min"),
  std::make_pair("art-lojban", "jbo"),
  std::make_pair("i-ami", "ami"),
  std::make_pair("i-bnn", "bnn"),
  std::make_pair("i-hak", "hak"),
  std::make_pair("i-klingon", "tlh"),
  std::make_pair("i-lux", "lb"),
  std::make_pair("i-navajo", "nv"),
  std::make_pair("i-pwn", "pwn"),
  std::make_pair("i-tao", "tao"),
  std::make_pair("i-tay", "tay"),
  std::make_pair("i-tsu", "tsu"),
  std::make_pair("no-bok", "nb"),
  std::make_pair("no-nyn", "nn"),
  std::make_pair("sgn-be-fr", "sfb"),
  std::make_pair("sgn-be-nl", "vgt"),
  std::make_pair("sgn-ch-de", "sgg"),
  std::make_pair("zh-guoyu", "cmn"),
  std::make_pair("zh-hakka", "hak"),
  std::make_pair("zh-min-nan", "nan"),
  std::make_pair("zh-xiang", "hsn")
} };

// Redundant tags are replaced to Preferred-Value.
// If tag don't provide Preferred-Value, we don't replace it.
typedef std::array<std::pair<string_view, string_view>, 25> RedundantArray;
static const RedundantArray kRedundant = { {
  std::make_pair("sgn-br", "bzs"),
  std::make_pair("sgn-co", "csn"),
  std::make_pair("sgn-de", "gsg"),
  std::make_pair("sgn-dk", "dsl"),
  std::make_pair("sgn-es", "ssp"),
  std::make_pair("sgn-fr", "fsl"),
  std::make_pair("sgn-gb", "bfi"),
  std::make_pair("sgn-gr", "gss"),
  std::make_pair("sgn-ie", "isg"),
  std::make_pair("sgn-it", "ise"),
  std::make_pair("sgn-jp", "jsl"),
  std::make_pair("sgn-mx", "mfs"),
  std::make_pair("sgn-ni", "ncs"),
  std::make_pair("sgn-nl", "dse"),
  std::make_pair("sgn-no", "nsl"),
  std::make_pair("sgn-pt", "psr"),
  std::make_pair("sgn-se", "swl"),
  std::make_pair("sgn-us", "ase"),
  std::make_pair("sgn-za", "sfs"),
  std::make_pair("zh-cmn", "cmn"),
  std::make_pair("zh-cmn-hans", "cmn-Hans"),
  std::make_pair("zh-cmn-hant", "cmn-Hant"),
  std::make_pair("zh-gan", "gan"),
  std::make_pair("zh-wuu", "wuu"),
  std::make_pair("zh-yue", "yue")
} };

// Language tags with Preferred-Value.
typedef std::array<std::pair<string_view, string_view>, 16> LanguageArray;
static const LanguageArray kLanguage = { {
  std::make_pair("in", "id"),
  std::make_pair("iw", "he"),
  std::make_pair("ji", "yi"),
  std::make_pair("jw", "jv"),
  std::make_pair("mo", "ro"),
  std::make_pair("ayx", "nun"),
  std::make_pair("cjr", "mom"),
  std::make_pair("cmk", "xch"),
  std::make_pair("drh", "khk"),
  std::make_pair("drw", "prs"),
  std::make_pair("gav", "dev"),
  std::make_pair("mst", "mry"),
  std::make_pair("myt", "mry"),
  std::make_pair("tie", "ras"),
  std::make_pair("tkk", "twm"),
  std::make_pair("tnf", "prs")
} };

// Region tags with Preferred-Value.
typedef std::array<std::pair<string_view, string_view>, 6> RegionArray;
static const RegionArray kRegion = { {
  std::make_pair("BU", "MM"),
  std::make_pair("DD", "DE"),
  std::make_pair("FX", "FR"),
  std::make_pair("TP", "TL"),
  std::make_pair("YD", "YE"),
  std::make_pair("ZR", "CD")
} };

// Variant tags with Preferred-Value.
typedef std::array<std::pair<string_view, string_view>, 1> VariantArray;
static const VariantArray kVariant = { {
  std::make_pair("heploc", "alalc97")
} };

// Extlang tags with Preferred-Value and Prefix.
typedef std::array<std::pair<string_view, std::pair<string_view, string_view> >, 225> ExtlangArray;  // NOLINT
static const ExtlangArray kExtlang = { {
  std::make_pair("aao", std::make_pair("aao", "ar")),
  std::make_pair("abh", std::make_pair("abh", "ar")),
  std::make_pair("abv", std::make_pair("abv", "ar")),
  std::make_pair("acm", std::make_pair("acm", "ar")),
  std::make_pair("acq", std::make_pair("acq", "ar")),
  std::make_pair("acw", std::make_pair("acw", "ar")),
  std::make_pair("acx", std::make_pair("acx", "ar")),
  std::make_pair("acy", std::make_pair("acy", "ar")),
  std::make_pair("adf", std::make_pair("adf", "ar")),
  std::make_pair("ads", std::make_pair("ads", "sgn")),
  std::make_pair("aeb", std::make_pair("aeb", "ar")),
  std::make_pair("aec", std::make_pair("aec", "ar")),
  std::make_pair("aed", std::make_pair("aed", "sgn")),
  std::make_pair("aen", std::make_pair("aen", "sgn")),
  std::make_pair("afb", std::make_pair("afb", "ar")),
  std::make_pair("afg", std::make_pair("afg", "sgn")),
  std::make_pair("ajp", std::make_pair("ajp", "ar")),
  std::make_pair("apc", std::make_pair("apc", "ar")),
  std::make_pair("apd", std::make_pair("apd", "ar")),
  std::make_pair("arb", std::make_pair("arb", "ar")),
  std::make_pair("arq", std::make_pair("arq", "ar")),
  std::make_pair("ars", std::make_pair("ars", "ar")),
  std::make_pair("ary", std::make_pair("ary", "ar")),
  std::make_pair("arz", std::make_pair("arz", "ar")),
  std::make_pair("ase", std::make_pair("ase", "sgn")),
  std::make_pair("asf", std::make_pair("asf", "sgn")),
  std::make_pair("asp", std::make_pair("asp", "sgn")),
  std::make_pair("asq", std::make_pair("asq", "sgn")),
  std::make_pair("asw", std::make_pair("asw", "sgn")),
  std::make_pair("auz", std::make_pair("auz", "ar")),
  std::make_pair("avl", std::make_pair("avl", "ar")),
  std::make_pair("ayh", std::make_pair("ayh", "ar")),
  std::make_pair("ayl", std::make_pair("ayl", "ar")),
  std::make_pair("ayn", std::make_pair("ayn", "ar")),
  std::make_pair("ayp", std::make_pair("ayp", "ar")),
  std::make_pair("bbz", std::make_pair("bbz", "ar")),
  std::make_pair("bfi", std::make_pair("bfi", "sgn")),
  std::make_pair("bfk", std::make_pair("bfk", "sgn")),
  std::make_pair("bjn", std::make_pair("bjn", "ms")),
  std::make_pair("bog", std::make_pair("bog", "sgn")),
  std::make_pair("bqn", std::make_pair("bqn", "sgn")),
  std::make_pair("bqy", std::make_pair("bqy", "sgn")),
  std::make_pair("btj", std::make_pair("btj", "ms")),
  std::make_pair("bve", std::make_pair("bve", "ms")),
  std::make_pair("bvl", std::make_pair("bvl", "sgn")),
  std::make_pair("bvu", std::make_pair("bvu", "ms")),
  std::make_pair("bzs", std::make_pair("bzs", "sgn")),
  std::make_pair("cdo", std::make_pair("cdo", "zh")),
  std::make_pair("cds", std::make_pair("cds", "sgn")),
  std::make_pair("cjy", std::make_pair("cjy", "zh")),
  std::make_pair("cmn", std::make_pair("cmn", "zh")),
  std::make_pair("coa", std::make_pair("coa", "ms")),
  std::make_pair("cpx", std::make_pair("cpx", "zh")),
  std::make_pair("csc", std::make_pair("csc", "sgn")),
  std::make_pair("csd", std::make_pair("csd", "sgn")),
  std::make_pair("cse", std::make_pair("cse", "sgn")),
  std::make_pair("csf", std::make_pair("csf", "sgn")),
  std::make_pair("csg", std::make_pair("csg", "sgn")),
  std::make_pair("csl", std::make_pair("csl", "sgn")),
  std::make_pair("csn", std::make_pair("csn", "sgn")),
  std::make_pair("csq", std::make_pair("csq", "sgn")),
  std::make_pair("csr", std::make_pair("csr", "sgn")),
  std::make_pair("czh", std::make_pair("czh", "zh")),
  std::make_pair("czo", std::make_pair("czo", "zh")),
  std::make_pair("doq", std::make_pair("doq", "sgn")),
  std::make_pair("dse", std::make_pair("dse", "sgn")),
  std::make_pair("dsl", std::make_pair("dsl", "sgn")),
  std::make_pair("dup", std::make_pair("dup", "ms")),
  std::make_pair("ecs", std::make_pair("ecs", "sgn")),
  std::make_pair("esl", std::make_pair("esl", "sgn")),
  std::make_pair("esn", std::make_pair("esn", "sgn")),
  std::make_pair("eso", std::make_pair("eso", "sgn")),
  std::make_pair("eth", std::make_pair("eth", "sgn")),
  std::make_pair("fcs", std::make_pair("fcs", "sgn")),
  std::make_pair("fse", std::make_pair("fse", "sgn")),
  std::make_pair("fsl", std::make_pair("fsl", "sgn")),
  std::make_pair("fss", std::make_pair("fss", "sgn")),
  std::make_pair("gan", std::make_pair("gan", "zh")),
  std::make_pair("gom", std::make_pair("gom", "kok")),
  std::make_pair("gse", std::make_pair("gse", "sgn")),
  std::make_pair("gsg", std::make_pair("gsg", "sgn")),
  std::make_pair("gsm", std::make_pair("gsm", "sgn")),
  std::make_pair("gss", std::make_pair("gss", "sgn")),
  std::make_pair("gus", std::make_pair("gus", "sgn")),
  std::make_pair("hab", std::make_pair("hab", "sgn")),
  std::make_pair("haf", std::make_pair("haf", "sgn")),
  std::make_pair("hak", std::make_pair("hak", "zh")),
  std::make_pair("hds", std::make_pair("hds", "sgn")),
  std::make_pair("hji", std::make_pair("hji", "ms")),
  std::make_pair("hks", std::make_pair("hks", "sgn")),
  std::make_pair("hos", std::make_pair("hos", "sgn")),
  std::make_pair("hps", std::make_pair("hps", "sgn")),
  std::make_pair("hsh", std::make_pair("hsh", "sgn")),
  std::make_pair("hsl", std::make_pair("hsl", "sgn")),
  std::make_pair("hsn", std::make_pair("hsn", "zh")),
  std::make_pair("icl", std::make_pair("icl", "sgn")),
  std::make_pair("ils", std::make_pair("ils", "sgn")),
  std::make_pair("inl", std::make_pair("inl", "sgn")),
  std::make_pair("ins", std::make_pair("ins", "sgn")),
  std::make_pair("ise", std::make_pair("ise", "sgn")),
  std::make_pair("isg", std::make_pair("isg", "sgn")),
  std::make_pair("isr", std::make_pair("isr", "sgn")),
  std::make_pair("jak", std::make_pair("jak", "ms")),
  std::make_pair("jax", std::make_pair("jax", "ms")),
  std::make_pair("jcs", std::make_pair("jcs", "sgn")),
  std::make_pair("jhs", std::make_pair("jhs", "sgn")),
  std::make_pair("jls", std::make_pair("jls", "sgn")),
  std::make_pair("jos", std::make_pair("jos", "sgn")),
  std::make_pair("jsl", std::make_pair("jsl", "sgn")),
  std::make_pair("jus", std::make_pair("jus", "sgn")),
  std::make_pair("kgi", std::make_pair("kgi", "sgn")),
  std::make_pair("knn", std::make_pair("knn", "kok")),
  std::make_pair("kvb", std::make_pair("kvb", "ms")),
  std::make_pair("kvk", std::make_pair("kvk", "sgn")),
  std::make_pair("kvr", std::make_pair("kvr", "ms")),
  std::make_pair("kxd", std::make_pair("kxd", "ms")),
  std::make_pair("lbs", std::make_pair("lbs", "sgn")),
  std::make_pair("lce", std::make_pair("lce", "ms")),
  std::make_pair("lcf", std::make_pair("lcf", "ms")),
  std::make_pair("liw", std::make_pair("liw", "ms")),
  std::make_pair("lls", std::make_pair("lls", "sgn")),
  std::make_pair("lsg", std::make_pair("lsg", "sgn")),
  std::make_pair("lsl", std::make_pair("lsl", "sgn")),
  std::make_pair("lso", std::make_pair("lso", "sgn")),
  std::make_pair("lsp", std::make_pair("lsp", "sgn")),
  std::make_pair("lst", std::make_pair("lst", "sgn")),
  std::make_pair("lsy", std::make_pair("lsy", "sgn")),
  std::make_pair("ltg", std::make_pair("ltg", "lv")),
  std::make_pair("lvs", std::make_pair("lvs", "lv")),
  std::make_pair("lzh", std::make_pair("lzh", "zh")),
  std::make_pair("max", std::make_pair("max", "ms")),
  std::make_pair("mdl", std::make_pair("mdl", "sgn")),
  std::make_pair("meo", std::make_pair("meo", "ms")),
  std::make_pair("mfa", std::make_pair("mfa", "ms")),
  std::make_pair("mfb", std::make_pair("mfb", "ms")),
  std::make_pair("mfs", std::make_pair("mfs", "sgn")),
  std::make_pair("min", std::make_pair("min", "ms")),
  std::make_pair("mnp", std::make_pair("mnp", "zh")),
  std::make_pair("mqg", std::make_pair("mqg", "ms")),
  std::make_pair("mre", std::make_pair("mre", "sgn")),
  std::make_pair("msd", std::make_pair("msd", "sgn")),
  std::make_pair("msi", std::make_pair("msi", "ms")),
  std::make_pair("msr", std::make_pair("msr", "sgn")),
  std::make_pair("mui", std::make_pair("mui", "ms")),
  std::make_pair("mzc", std::make_pair("mzc", "sgn")),
  std::make_pair("mzg", std::make_pair("mzg", "sgn")),
  std::make_pair("mzy", std::make_pair("mzy", "sgn")),
  std::make_pair("nan", std::make_pair("nan", "zh")),
  std::make_pair("nbs", std::make_pair("nbs", "sgn")),
  std::make_pair("ncs", std::make_pair("ncs", "sgn")),
  std::make_pair("nsi", std::make_pair("nsi", "sgn")),
  std::make_pair("nsl", std::make_pair("nsl", "sgn")),
  std::make_pair("nsp", std::make_pair("nsp", "sgn")),
  std::make_pair("nsr", std::make_pair("nsr", "sgn")),
  std::make_pair("nzs", std::make_pair("nzs", "sgn")),
  std::make_pair("okl", std::make_pair("okl", "sgn")),
  std::make_pair("orn", std::make_pair("orn", "ms")),
  std::make_pair("ors", std::make_pair("ors", "ms")),
  std::make_pair("pel", std::make_pair("pel", "ms")),
  std::make_pair("pga", std::make_pair("pga", "ar")),
  std::make_pair("pks", std::make_pair("pks", "sgn")),
  std::make_pair("prl", std::make_pair("prl", "sgn")),
  std::make_pair("prz", std::make_pair("prz", "sgn")),
  std::make_pair("psc", std::make_pair("psc", "sgn")),
  std::make_pair("psd", std::make_pair("psd", "sgn")),
  std::make_pair("pse", std::make_pair("pse", "ms")),
  std::make_pair("psg", std::make_pair("psg", "sgn")),
  std::make_pair("psl", std::make_pair("psl", "sgn")),
  std::make_pair("pso", std::make_pair("pso", "sgn")),
  std::make_pair("psp", std::make_pair("psp", "sgn")),
  std::make_pair("psr", std::make_pair("psr", "sgn")),
  std::make_pair("pys", std::make_pair("pys", "sgn")),
  std::make_pair("rms", std::make_pair("rms", "sgn")),
  std::make_pair("rsi", std::make_pair("rsi", "sgn")),
  std::make_pair("rsl", std::make_pair("rsl", "sgn")),
  std::make_pair("sdl", std::make_pair("sdl", "sgn")),
  std::make_pair("sfb", std::make_pair("sfb", "sgn")),
  std::make_pair("sfs", std::make_pair("sfs", "sgn")),
  std::make_pair("sgg", std::make_pair("sgg", "sgn")),
  std::make_pair("sgx", std::make_pair("sgx", "sgn")),
  std::make_pair("shu", std::make_pair("shu", "ar")),
  std::make_pair("slf", std::make_pair("slf", "sgn")),
  std::make_pair("sls", std::make_pair("sls", "sgn")),
  std::make_pair("sqs", std::make_pair("sqs", "sgn")),
  std::make_pair("ssh", std::make_pair("ssh", "ar")),
  std::make_pair("ssp", std::make_pair("ssp", "sgn")),
  std::make_pair("ssr", std::make_pair("ssr", "sgn")),
  std::make_pair("svk", std::make_pair("svk", "sgn")),
  std::make_pair("swc", std::make_pair("swc", "sw")),
  std::make_pair("swh", std::make_pair("swh", "sw")),
  std::make_pair("swl", std::make_pair("swl", "sgn")),
  std::make_pair("syy", std::make_pair("syy", "sgn")),
  std::make_pair("tmw", std::make_pair("tmw", "ms")),
  std::make_pair("tse", std::make_pair("tse", "sgn")),
  std::make_pair("tsm", std::make_pair("tsm", "sgn")),
  std::make_pair("tsq", std::make_pair("tsq", "sgn")),
  std::make_pair("tss", std::make_pair("tss", "sgn")),
  std::make_pair("tsy", std::make_pair("tsy", "sgn")),
  std::make_pair("tza", std::make_pair("tza", "sgn")),
  std::make_pair("ugn", std::make_pair("ugn", "sgn")),
  std::make_pair("ugy", std::make_pair("ugy", "sgn")),
  std::make_pair("ukl", std::make_pair("ukl", "sgn")),
  std::make_pair("uks", std::make_pair("uks", "sgn")),
  std::make_pair("urk", std::make_pair("urk", "ms")),
  std::make_pair("uzn", std::make_pair("uzn", "uz")),
  std::make_pair("uzs", std::make_pair("uzs", "uz")),
  std::make_pair("vgt", std::make_pair("vgt", "sgn")),
  std::make_pair("vkk", std::make_pair("vkk", "ms")),
  std::make_pair("vkt", std::make_pair("vkt", "ms")),
  std::make_pair("vsi", std::make_pair("vsi", "sgn")),
  std::make_pair("vsl", std::make_pair("vsl", "sgn")),
  std::make_pair("vsv", std::make_pair("vsv", "sgn")),
  std::make_pair("wuu", std::make_pair("wuu", "zh")),
  std::make_pair("xki", std::make_pair("xki", "sgn")),
  std::make_pair("xml", std::make_pair("xml", "sgn")),
  std::make_pair("xmm", std::make_pair("xmm", "ms")),
  std::make_pair("xms", std::make_pair("xms", "sgn")),
  std::make_pair("yds", std::make_pair("yds", "sgn")),
  std::make_pair("ysl", std::make_pair("ysl", "sgn")),
  std::make_pair("yue", std::make_pair("yue", "zh")),
  std::make_pair("zib", std::make_pair("zib", "sgn")),
  std::make_pair("zlm", std::make_pair("zlm", "ms")),
  std::make_pair("zmi", std::make_pair("zmi", "ms")),
  std::make_pair("zsl", std::make_pair("zsl", "sgn")),
  std::make_pair("zsm", std::make_pair("zsm", "ms"))
} };

typedef std::unordered_map<std::string, std::string> TagMap;

inline const TagMap& Grandfathered() {
  static const TagMap map(kGrandfathered.begin(), kGrandfathered.end());
  return map;
}

inline const TagMap& Redundant() {
  static const TagMap map(kRedundant.begin(), kRedundant.end());
  return map;
}

inline const TagMap& Language() {
  static const TagMap map(kLanguage.begin(), kLanguage.end());
  return map;
}

inline const TagMap& Region() {
  static const TagMap map(kRegion.begin(), kRegion.end());
  return map;
}

inline const TagMap& Variant() {
  static const TagMap map(kVariant.begin(), kVariant.end());
  return map;
}

typedef std::unordered_map<std::string, std::pair<std::string, std::string> > ExtlangMap;  // NOLINT

inline const ExtlangMap& Extlang() {
  static const ExtlangMap map(kExtlang.begin(), kExtlang.end());
  return map;
}

} } } }  // namespace iv::core::i18n::data
#endif  // IV_I18N_LANGUAGE_TAG_H_
