
#include "partition_info.h"

/*
  Global Vector X has nx * ny elements. 
  we partition it into 
 */
#define U(i)     4*(i)
#define V(i)     4*(i)+1
#define Omega(i) 4*(i)+2
#define Temp(i)  4*(i)+3

template <class Vec>
void initial_guess(Vec& X, Info& info) {
  int nx = info.nx;
  int local_nx_begin = info.local_nx_begin;
  int local_nx_end   = info.local_nx_end;
  int local_ny_begin = info.local_ny_begin;
  int local_ny_end   = info.local_ny_end;
  double grashof = info.grashof;


  int i, j, k=0;

  for (j=local_ny_begin; j<local_ny_end; ++j) {
    int row = (j - local_ny_begin) * nx;
    for (i=local_nx_begin; i<local_nx_end; ++i) {
      k = row +  i - local_nx_begin;
      X[U(k)] = 0.0;
      X[V(k)] = 0.0;
      X[Omega(k)] = 0.0;
      X[Temp(k)] = double(grashof>0)*double(i)/double(nx-1);
    }
  }

}
