//==========================================================================
//       CVS Information:
//
//	     $RCSfile: parser.h,v $  $Revision: 1.2 $  $State: Exp $ 	
//	     $Author: llee $  $Date: 2001/10/26 16:15:09 $ 	
//	     $Locker:  $ 	
//---------------------------------------------------------------------------
//	                                                                     
//	 DESCRIPTION                                                         
//	                                                                     
//---------------------------------------------------------------------------
//
//       LICENSE AGREEMENT
//=======================================================================
// Copyright (C) 1997-2001
// Authors: Andrew Lumsdaine <lums@osl.iu.edu> 
//          Lie-Quan Lee     <llee@osl.iu.edu>
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Iterative Template Library along with the software;  see the
// file LICENSE.  
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//=======================================================================
//---------------------------------------------------------------------------
//	                                                                   
//	 REVISION HISTORY:                                                 
//	                                                                   
//	 $Log: parser.h,v $
//	 Revision 1.2  2001/10/26 16:15:09  llee
//	 *** empty log message ***
//	
//	 Revision 1.1  2001/10/19 05:23:06  llee
//	 *** empty log message ***
//	
//	 Revision 1.3  2001/10/18 21:37:05  llee
//	 *** empty log message ***
//	
//	 Revision 1.2  2000/07/18 14:30:44  llee1
//	 *** empty log message ***
//	
//	 Revision 1.2  2000/07/17 15:44:07  llee1
//	 *** empty log message ***
//		
//	                                                                    
//===========================================================================
#ifndef COMMAND_LINE_PARSER_H
#define COMMAND_LINE_PARSER_H

#include <string>
#include <map>
#include <itl/itl_config.h>

namespace std {

  class parser {
  public:
    parser(int argc, char* argv[], const string& delim = "--");

    //register flags will be used in the command line.
    void register_flag (const string& flag, int i, 
			const string& message = string("no description."));
    
    //check if two flags should or shold not coexist in the command line.
    bool flags_coexist (const string& flag1, const string& flag2, 
			bool coexist = true);

#if defined ITL_NO_SSTREAM
    void get(const string& flag, double& value, double d = 0.);
    void get(const string& flag, int& value, int d = 0);
#else
    template <class T>
    void get(const string& flag, T& value, const T& d = T());
#endif
    void get(const string& flag, string& value, const string& d);
    void help();

  protected:

    void remove_special_character(string&, char c);

    void split(const string& delim, const string& raw_data);
    
    //str is one unit include a flag and its (possible) value(s)
    //it is not allowed that str is started " "
    void halve(const string& str);
    
  private:
    map<string, string> seg;      //values in string format for flags
    map<string, string> messages; //describe flags
    map<string, int> registers;   //registered flags
  };


}


#endif
