//==========================================================================
//       CVS Information:
//
//	     $RCSfile: laplacian.h,v $  $Revision: 1.2 $  $State: Exp $ 	
//	     $Author: llee1 $  $Date: 2000/07/17 15:44:06 $ 	
//	     $Locker:  $ 	
//---------------------------------------------------------------------------
//	                                                                     
//	 DESCRIPTION                                                         
//	                                                                     
//---------------------------------------------------------------------------
//
//       LICENSE AGREEMENT
//=======================================================================
// Copyright (C) 1997-2001
// Authors: Andrew Lumsdaine <lums@osl.iu.edu> 
//          Lie-Quan Lee     <llee@osl.iu.edu>
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Iterative Template Library along with the software;  see the
// file LICENSE.  
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//=======================================================================
//---------------------------------------------------------------------------
//	                                                                   
//	 REVISION HISTORY:                                                 
//	                                                                   
//	 $Log: laplacian.h,v $
//	 Revision 1.2  2000/07/17 15:44:06  llee1
//	 *** empty log message ***
//		
//	                                                                    
//===========================================================================

#ifndef LAPLACIAN_GENERATOR_H
#define LAPLACIAN_GENERATOR_H

template <class Matrix>
void
generate_laplacian_2D(Matrix& A, int mx, int my) {
  int row = 0;
  int i, j;
  const double two = 2.0, one = 1.0;
  const double hx = one/(double)(mx-1);  
  const double hy = one/(double)(my-1);
  const double hxdhy = hx/hy; 
  const double hydhx = hy/hx;

  for (j=0; j<my; ++j) {
    int base = j*mx;
    for (i=0; i<mx; ++i) {
      row = base + i;
      if ( j ) A(row, row - mx) = -hxdhy;
      if ( i ) A(row, row - 1)  = -hydhx;
      A(row, row) = two*(hydhx+hxdhy);
      if ( i != mx-1 ) A(row, row + 1)  = -hydhx;
      if ( j != my-1 ) A(row, row + mx) = -hxdhy;
    }
  }
  
}

template <class Matrix>
void
generate_laplacian_3D(Matrix& A, int q) {
  int row = 0;
  int i, j, k;
  int q2 = q*q;

  for (k=0; k<q; ++k) {
    for (j=0; j<q; ++j){ 
      for (i=0; i<q; ++i) {
	if ( k ) A(row, row - q2) = -1.;
	if ( j ) A(row, row - q)  = -1.;
	if ( i ) A(row, row - 1)  = -1.;
	A(row, row) = 6.;
	if ( i != q-1 ) A(row, row + 1)  = -1.;
	if ( j != q-1 ) A(row, row + q)  = -1.;
	if ( k != q-1 ) A(row, row + q2) = -1.;

	++row;
      }
    }
  }
}

#endif
