//===========================================================================
//  CVS Information:                                                         
//                                                                           
//     $RCSfile: diag_richardson.cpp,v $  $Revision: 1.1 $  $State: Exp $ 
//     $Author: llee $  $Date: 2001/10/23 02:33:56 $ 
//     $Locker:  $ 
//---------------------------------------------------------------------------
//                                                                           
// DESCRIPTION                                                               
//                                                                           
//---------------------------------------------------------------------------
//                                                                           
// LICENSE AGREEMENT                                                         
// Copyright 1997, University of Notre Dame.
// Authors: Andrew Lumsdaine, Lie-Quan Lee
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Iterative Template Library along with the software;  see the
// file LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN  46556.
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//---------------------------------------------------------------------------
//                                                                           
// REVISION HISTORY:                                                         
//                                                                           
// $Log: diag_richardson.cpp,v $
// Revision 1.1  2001/10/23 02:33:56  llee
// *** empty log message ***
//
// Revision 1.3  2000/07/27 15:50:22  llee1
// for vc++
//
// Revision 1.2  2000/07/27 04:39:20  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/26 21:50:02  llee1
// change file extension from .cc to .cpp
//
// Revision 1.2  2000/07/17 15:44:07  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/14 20:39:03  llee1
// *** empty log message ***
//
//===========================================================================

#include "mtl/matrix.h"
#include "mtl/mtl.h"
#include "mtl/utils.h"

#include <itl/interface/mtl.h>
#include "itl/preconditioner/diagonal.h"
#include "itl/krylov/richardson.h"

#include "laplacian.h"

#include "parser.h"

using namespace mtl;
using namespace itl;

typedef  double Type;

//begin
typedef matrix< Type, 
                symmetric<upper>, 
	        array< compressed<> >, 
                row_major >::type Matrix;
//end

int main (int argc, char* argv[]) 
{
  using std::cout;
  using std::endl;
  using std::parser;

  if ( argc == 1 ) {
    cout << argv[0] << " --help will get your the usage of flags." << endl;
  }

  parser myparser(argc, argv);

  myparser.register_flag("--mx", 1, "number of points in x axis in the mesh");
  myparser.register_flag("--my", 1, "number of points in y axis in the mesh");
  myparser.register_flag("--max_it", 1, "maxmal iteration allowed");  
  myparser.register_flag("--ksp_atol", 1, "Absolute tolerance in KSP iteration");  
  myparser.register_flag("--ksp_rtol", 1, "Relative tolerance in KSP iteration");  

  myparser.help();
  int mx, my, max_it;
  double ksp_atol, ksp_rtol;

  myparser.get("--mx", mx, 16);
  myparser.get("--my", my, mx);
  myparser.get("--max_it", max_it, mx*my);
  myparser.get("--ksp_atol", ksp_atol);
  myparser.get("--ksp_rtol", ksp_rtol, 1.0e-6);

  const int N = mx * my;

  Matrix A(N);
  generate_laplacian_2D(A, mx, my);

  dense1D<Type> x(A.nrows(), Type(0));
  dense1D<Type> b(A.ncols());
  for (dense1D<Type>::iterator i=b.begin(); i!=b.end(); i++)
    *i = 1;

  diagonal_precond<Matrix> precond(A);

  noisy_iteration<double> iter(b, max_it, ksp_rtol, ksp_atol);

  //gmres algorithm
  richardson(A, x, b, precond(), iter);
  //end

  //verify the result
  dense1D<Type> b1(A.ncols());
  itl::mult(A, x, b1);
  itl::add(b1, itl::scaled(b, -1.), b1);

  cout << "Number of iterations: " << iter.iterations() 
       << " True Residual: " << itl::two_norm(b1) << endl;

  return 0;
}


