//===========================================================================
//  CVS Information:                                                         
//                                                                           
//     $RCSfile: qmr.cpp,v $  $Revision: 1.3 $  $State: Exp $ 
//     $Author: llee $  $Date: 2001/10/18 16:57:11 $ 
//     $Locker:  $ 
//---------------------------------------------------------------------------
//                                                                           
// DESCRIPTION                                                               
//                                                                           
//---------------------------------------------------------------------------
//                                                                           
// LICENSE AGREEMENT                                                         
// Copyright 1997, University of Notre Dame.
// Authors: Andrew Lumsdaine, Lie-Quan Lee
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Matrix Template Library along with the software;  see the
// file LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN  46556.
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//---------------------------------------------------------------------------
//                                                                           
// REVISION HISTORY:                                                         
//                                                                           
// $Log: qmr.cpp,v $
// Revision 1.3  2001/10/18 16:57:11  llee
// *** empty log message ***
//
// Revision 1.2  2000/07/27 19:51:14  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/26 21:49:47  llee1
// change file extension from .cc to .cpp
//
// Revision 1.1  2000/07/17 15:44:06  llee1
// *** empty log message ***
//
// Revision 1.5  2000/03/19 21:06:13  llee1
// *** empty log message ***
//
// Revision 1.4  2000/02/02 02:30:21  llee1
// *** empty log message ***
//
// Revision 1.3  1999/11/30 19:50:00  llee1
// *** empty log message ***
//
// Revision 1.2  1999/11/29 01:41:02  llee1
// *** empty log message ***
//
// Revision 1.1  1999/11/29 00:44:27  llee1
// *** empty log message ***
//
//                                                                           
//===========================================================================
#if defined ITL_USING_MTL
#include "mtl/dense1D.h"
#include "mtl/matrix.h"
#include "mtl/mtl.h"
#include "mtl/utils.h"

#include "itl/interface/mtl.h"
#else
#include "my_interface.h"
#endif


#include "itl/krylov/qmr.h"
#include <vector>
#include <iostream>

/*
  In thsi example, we show how to use QMR algorithm, the output should be:

iteration 0: resid 1
iteration 1: resid 0.411693
iteration 2: resid 0.357205
iteration 3: resid 0.28416
iteration 4: resid 0.323778
iteration 5: resid 3.5064e-14
finished! error code = 0
5 iterations
3.5064e-14 final residual
     1      2      0      0      3   x          0.205847  =       1
     4      5      0      6      0   x         0.0419363  =       1
     0      7      8      0      9   x         -0.178049  =       1
     0      0     10     11     12   x       -0.00551162  =       1
     0      0     13      0     14   x           0.23676  =       1
*/

typedef  double Type;

#if defined ITL_USING_MTL
typedef mtl::matrix< Type, mtl::rectangle<>,
		     mtl::array< mtl::compressed<> >,
		     mtl::row_major >::type Matrix;


typedef mtl::dense1D<Type>  Vector;

#else

typedef std::vector<Type>   Vector;
typedef std::vector<Vector> Matrix;

#endif

int main()
{
  using std::cout;
  using std::endl;

  using itl::nrows; 
  using itl::identity_preconditioner;
  using itl::noisy_iteration;
  using itl::qmr;
  using itl::mult;
  using itl::add;
  using itl::scaled;
  using itl::two_norm;

  int max_iter = 50;
  //begin
#if defined ITL_USING_MTL
  Matrix A(5, 5);
  // Fill matrix...
  //end
  A(0, 0) = 1.0;
  A(0, 1) = 2.0;
  A(0, 4) = 3.0;
  A(1, 0) = 4.0;
  A(1, 1) = 5.0;
  A(1, 3) = 6.0;
  A(2, 1) = 7.0;
  A(2, 2) = 8.0;
  A(2, 4) = 9.0;
  A(3, 2) = 10.;
  A(3, 3) = 11.;
  A(3, 4) = 12.;
  A(4, 2) = 13.; 
  A(4, 4) = 14.;
#else
  Matrix A(5, Vector(5));
  A[0][0] = 1.;
  A[0][1] = 2.0;
  A[0][4] = 3.0;
  A[1][0] = 4.0;
  A[1][1] = 5.0;
  A[1][3] = 6.0;
  A[2][1] = 7.0;
  A[2][2] = 8.0;
  A[2][4] = 9.0;
  A[3][2] = 10.;
  A[3][3] = 11.;
  A[3][4] = 12.;
  A[4][2] = 13.; 
  A[4][4] = 14.;
#endif
  //begin
  Vector x(nrows(A), Type(0));
  Vector b(nrows(A));
  for (Vector::iterator i=b.begin(); i!=b.end(); i++)
    *i = 1.;

  identity_preconditioner precond;
  //iteration
  noisy_iteration<double> iter(b, max_iter, 1e-6);
  //qmr algorithm
  qmr(A, x, b, precond.left(), precond.right(), iter);
  //end

  //verify the result
  Vector b1(nrows(A));
  itl::mult(A, x, b1);
  itl::add(b1, scaled(b, -1.), b1);

  if ( itl::two_norm(b1) < 1.e-6) { //output
    for (int i=0; i<5; i++) {
      for (int j=0; j<5; j++) {
	cout.width(6);
#if defined ITL_USING_MTL
	cout << A(i,j) << " ";
#else
	cout << A[i][j] << " ";
#endif
      }
      cout << "  x  ";
      cout.width(16);
      cout << x[i] << "  =  ";
      cout.width(6);
      cout << b[i] << endl;
    }
  } else {
    cout << "Residual " << iter.resid() << endl;
  }

  return 0;
  }


