//===========================================================================
//  CVS Information:                                                         
//                                                                           
//     $RCSfile: bicg.cpp,v $  $Revision: 1.2 $  $State: Exp $ 
//     $Author: llee $  $Date: 2001/10/18 16:57:11 $ 
//     $Locker:  $ 
//---------------------------------------------------------------------------
//                                                                           
// DESCRIPTION                                                               
//                                                                           
//---------------------------------------------------------------------------
//                                                                           
// LICENSE AGREEMENT                                                         
// Copyright 1997, University of Notre Dame.
// Authors: Andrew Lumsdaine, Lie-Quan Lee
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Matrix Template Library along with the software;  see the
// file LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN  46556.
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//---------------------------------------------------------------------------
//                                                                           
// REVISION HISTORY:                                                         
//                                                                           
// $Log: bicg.cpp,v $
// Revision 1.2  2001/10/18 16:57:11  llee
// *** empty log message ***
//
// Revision 1.1  2000/07/26 21:49:36  llee1
// change file extension from .cc to .cpp
//
// Revision 1.1  2000/07/17 15:44:05  llee1
// *** empty log message ***
//
// Revision 1.4  2000/03/19 21:06:12  llee1
// *** empty log message ***
//
// Revision 1.3  1999/11/30 19:50:00  llee1
// *** empty log message ***
//
// Revision 1.2  1999/11/29 01:41:02  llee1
// *** empty log message ***
//
// Revision 1.1  1999/11/29 00:44:26  llee1
// *** empty log message ***
//
//                                                                           
//===========================================================================
#include "my_interface.h"
#include "itl/krylov/bicg.h"

#include <vector>
#include <iostream>

/*
iteration 0: resid 2.23607
iteration 1: resid 1.26885
iteration 2: resid 7.45429
iteration 3: resid 0.914196
iteration 4: resid 0.0687568
iteration 5: resid 7.14056e-14
finished! error code = 0
5 iterations
7.14056e-14 is actual final residual.
3.19336e-14 is actual relative tolerance achieved.
Relative tol: 1e-06  Absolute tol: 0
     1      2      0      0      3   x       -0.00231648  =       1
     4      5      0      6      0   x          0.250579  =       1
     0      7      8      0      9   x        -0.0354661  =       1
     0      0     10     11     12   x        -0.0457704  =       1
     0      0     13      0     14   x          0.133956  =       1
True Residual: 7.17204e-14
*/


using namespace itl;
using namespace std;

typedef  double Type;
typedef std::vector<std::vector<Type> > Matrix;
typedef std::vector<Type>               Vector;

int main()
{
  using std::cout;
  using std::endl;
  int max_iter = 50;
  //begin

  Matrix A(5, std::vector<Type>(5));
  A[0][0] = 1.;
  A[0][1] = 2.0;
  A[0][4] = 3.0;
  A[1][0] = 4.0;
  A[1][1] = 5.0;
  A[1][3] = 6.0;
  A[2][1] = 7.0;
  A[2][2] = 8.0;
  A[2][4] = 9.0;
  A[3][2] = 10.;
  A[3][3] = 11.;
  A[3][4] = 12.;
  A[4][2] = 13.; 
  A[4][4] = 14.;

  //begin
  Vector x(nrows(A), Type(0));
  Vector b(nrows(A));
  for (Vector::iterator i=b.begin(); i!=b.end(); i++)
    *i = 1.;

  identity_preconditioner precond;
  //iteration
  noisy_iteration<double> iter(b, max_iter, 1e-6);
  //qmr algorithm
  bicg(A, x, b, precond(), iter);
  //end

  //verify the result
  Vector b1(nrows(A));
  itl::mult(A, x, b1);
  itl::add(b1, scaled(b, -1.), b1);

  if ( itl::two_norm(b1) < 1.e-6) { //output
    for (int i=0; i<5; i++) {
      for (int j=0; j<5; j++) {
	cout.width(6);
	cout << A[i][j] << " ";
      }
      cout << "  x  ";
      cout.width(16);
      cout << x[i] << "  =  ";
      cout.width(6);
      cout << b[i] << endl;
    }
  } else {
    cout << "Residual " << iter.resid() << endl;
  }

  cout << "True Residual: " << itl::two_norm(b1) << endl;
  return 0;
  }


