//===========================================================================
//  CVS Information:                                                         
//                                                                           
//     $RCSfile: gmres_classical_gram_schmidt.cpp,v $  $Revision: 1.3 $  $State: Exp $ 
//     $Author: llee $  $Date: 2001/10/18 18:55:03 $ 
//     $Locker:  $ 
//---------------------------------------------------------------------------
//                                                                           
// DESCRIPTION                                                               
//                                                                           
//---------------------------------------------------------------------------
//                                                                           
// LICENSE AGREEMENT                                                         
// Copyright 1997, University of Notre Dame.
// Authors: Andrew Lumsdaine, Lie-Quan Lee
//
// This file is part of the Iterative Template Library
//
// You should have received a copy of the License Agreement for the
// Matrix Template Library along with the software;  see the
// file LICENSE.  If not, contact Office of Research, University of Notre
// Dame, Notre Dame, IN  46556.
//
// Permission to modify the code and to distribute modified code is
// granted, provided the text of this NOTICE is retained, a notice that
// the code was modified is included with the above COPYRIGHT NOTICE and
// with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
// file is distributed with the modified code.
//
// LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
// By way of example, but not limitation, Licensor MAKES NO
// REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
// OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
// OR OTHER RIGHTS.
//---------------------------------------------------------------------------
//                                                                           
// REVISION HISTORY:                                                         
//                                                                           
// $Log: gmres_classical_gram_schmidt.cpp,v $
// Revision 1.3  2001/10/18 18:55:03  llee
// *** empty log message ***
//
// Revision 1.2  2001/10/18 15:44:31  llee
// compile and test for examples
//
// Revision 1.1  2000/07/26 21:49:25  llee1
// change file extension from .cc to .cpp
//
// Revision 1.2  2000/07/26 14:52:23  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/26 04:19:35  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/19 19:58:00  llee1
// *** empty log message ***
//
// Revision 1.1  2000/07/17 15:44:06  llee1
// *** empty log message ***
//
// Revision 1.1  2000/03/19 21:17:37  llee1
// *** empty log message ***
//
// Revision 1.3  1999/11/30 19:50:00  llee1
// *** empty log message ***
//
// Revision 1.2  1999/11/29 01:41:02  llee1
// *** empty log message ***
//
// Revision 1.1  1999/11/29 00:44:26  llee1
// *** empty log message ***
//
//                                                                           
//===========================================================================
#include "itl/interface/blas.h"
#include "itl/krylov/gmres.h"

#include <vector>
#include <iostream>
/*
  In thsi example, we show how to use GMRES algorithm, the output should be:

  teration 0: resid 1
  iteration 1: resid 0.480381
  iteration 2: resid 0.341156
  iteration 3: resid 0.234932
  iteration 4: resid 0.118403
  iteration 5: resid 8.04725e-16
  iteration 5: resid 6.18013e-16
  finished! error code = 0
  5 iterations
  6.18013e-16 final residual
    10      2      0      0      3   x           9.61541  =     100
     2     50      7      6      0   x           1.36768  =     100
     0      7     80      0      9   x           1.08868  =     100
     0      6      0    110     12   x          0.794106  =     100
     3      0      9     12    140   x          0.370188  =     100
*/
using namespace itl;
using namespace std;

typedef  double Type;

typedef sparse_matrix<Type> Matrix;
typedef std::vector<Type> Vector;


int main()
{
  using std::cout; using std::endl;

  int max_iter = 50;

  std::vector<double> val(14);
  std::vector<int> ind(14);
  std::vector<int> ptr(6);
  for (int i = 0; i<14;i++) val[i] = i+1;
//   Matrix A(5, 5);
//   A(0, 0) = 1.0;
  ptr[0] = 0;
  ind[0] = 0;
//   A(0, 1) = 2.0;
  ind[1] = 1;
//   A(0, 4) = 3.0;
  ind[2] = 4;
  ptr[1] = 3;
//   A(1, 0) = 4.0;
  ind[3] = 0;
//   A(1, 1) = 5.0;
  ind[4] = 1;
//   A(1, 3) = 6.0;
  ind[5] = 3;
  ptr[2] = 6;
//   A(2, 1) = 7.0;
  ind[6] = 1;
//   A(2, 2) = 8.0;
  ind[7] = 2;
//   A(2, 4) = 9.0;
  ind[8] = 4;
  ptr[3] = 9;
//   A(3, 2) = 10.;
  ind[9] = 2;
//   A(3, 3) = 11.;
  ind[10] = 3;
//   A(3, 4) = 12.;
  ind[11] = 4;
  ptr[4] = 12;
//   A(4, 2) = 13.; 
  ind[12] = 2;
//   A(4, 4) = 14.;
  ind[13] = 4;
  ptr[5] = 14;

  //begin
  Matrix A(5, 5, 14, &val[0], &ind[0], &ptr[0]);
  //end

  //begin
  Vector x(nrows(A), Type(0));
  Vector b(nrows(A));
  for (Vector::iterator i=b.begin(); i!=b.end(); i++)
    *i = 100.;

  identity_preconditioner precond;

  Vector b2(b.size(), 0);
  solve(precond, b, b2);

  //iteration
  noisy_iteration<double> iter(b2, max_iter, 1e-12);
  int restart = 20;
  classical_gram_schmidt<Vector> KS(restart, size(x));
  
  itl::gmres(A, x, b, precond(), restart, iter, KS);
  //end

  //verify the result
  Vector b1(nrows(A));
  itl::mult(A, x, b1);
  itl::add(itl::scaled(b, -1.), b1);

  cout << "Residual " << itl::two_norm(b1) << endl;

  return 0;
}


