%{!?rel:%define rel 1%{?dist}}
%{!?version:%define version 2.0.2}
%{!?pkgname:%define pkgname iplike}
%{!?postgresql_dev:%define postgresql_dev postgresql-devel}

%define _libdir %(pg_config --pkglibdir)

Name: %{pkgname}
Version: %{version}
Release: %{rel}
License: GPL
Group: Applications/Databases
Summary: PostgreSQL complex IP Address text field query
Source: %{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root

BuildRequires: %{postgresql_dev}, gcc
Requires: sudo

%description
PostgreSQL function for doing complex IP address queries
on a text field.

%prep
%setup -n %{name}-%{version}

%build
%configure
make

%install
make install DESTDIR="$RPM_BUILD_ROOT"

%post

if [ -z "$SKIP_IPLIKE_INSTALL" ]; then

	FAILED=0

	echo -e "- installing iplike into the opennms db (if it exists)... \c"
	if %{_sbindir}/install_iplike.sh -s postgres -d opennms >>/tmp/install_iplike.log 2>&1; then
		echo "OK"
	else
		echo "failed"
#		FAILED=1
	fi

	if [ $FAILED -eq 1 ]; then
		cat <<END

!!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!! WARNING !!!

Failed to install iplike into the opennms database.
See /tmp/install_iplike.log for details.

To install iplike into your database, use the %{_sbindir}/install_iplike.sh
script.  See \`install_iplike.sh -h\` for more details.

END

		exit 0
	fi

fi

exit 0

%clean
if [ "$RPM_BUILD_ROOT" != "/" ]; then
	rm -rf "$RPM_BUILD_ROOT"
fi

%files
%attr(755,root,root) %{_libdir}/iplike*
%attr(755,root,root) %{_sbindir}/install_iplike.sh

%changelog
* Mon Jun 18 2007 Benjamin Reed <ranger@opennms.org>
- add RPM build to the autotools stuff
- add postinstall to insert iplike into template1
- many other RPM-related fixes

* Wed Jun 13 2007 Benjamin Reed <ranger@opennms.org>
- initial package
