# Copyright 2013 the V8 project authors. All rights reserved.
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above
#       copyright notice, this list of conditions and the following
#       disclaimer in the documentation and/or other materials provided
#       with the distribution.
#     * Neither the name of Google Inc. nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# This file is automatically generated from the V8 source and should not
# be modified manually, run 'make grokdump' instead to update this file.

# List of known V8 instance types.
INSTANCE_TYPES = {
  64: "STRING_TYPE",
  68: "ONE_BYTE_STRING_TYPE",
  65: "CONS_STRING_TYPE",
  69: "CONS_ONE_BYTE_STRING_TYPE",
  67: "SLICED_STRING_TYPE",
  71: "SLICED_ONE_BYTE_STRING_TYPE",
  66: "EXTERNAL_STRING_TYPE",
  70: "EXTERNAL_ONE_BYTE_STRING_TYPE",
  74: "EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  82: "SHORT_EXTERNAL_STRING_TYPE",
  86: "SHORT_EXTERNAL_ONE_BYTE_STRING_TYPE",
  90: "SHORT_EXTERNAL_STRING_WITH_ONE_BYTE_DATA_TYPE",
  0: "INTERNALIZED_STRING_TYPE",
  4: "ONE_BYTE_INTERNALIZED_STRING_TYPE",
  2: "EXTERNAL_INTERNALIZED_STRING_TYPE",
  6: "EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  10: "EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  18: "SHORT_EXTERNAL_INTERNALIZED_STRING_TYPE",
  22: "SHORT_EXTERNAL_ONE_BYTE_INTERNALIZED_STRING_TYPE",
  26: "SHORT_EXTERNAL_INTERNALIZED_STRING_WITH_ONE_BYTE_DATA_TYPE",
  128: "SYMBOL_TYPE",
  129: "MAP_TYPE",
  130: "CODE_TYPE",
  131: "ODDBALL_TYPE",
  181: "CELL_TYPE",
  183: "PROPERTY_CELL_TYPE",
  132: "HEAP_NUMBER_TYPE",
  133: "MUTABLE_HEAP_NUMBER_TYPE",
  134: "FOREIGN_TYPE",
  135: "BYTE_ARRAY_TYPE",
  136: "FREE_SPACE_TYPE",
  137: "EXTERNAL_INT8_ARRAY_TYPE",
  138: "EXTERNAL_UINT8_ARRAY_TYPE",
  139: "EXTERNAL_INT16_ARRAY_TYPE",
  140: "EXTERNAL_UINT16_ARRAY_TYPE",
  141: "EXTERNAL_INT32_ARRAY_TYPE",
  142: "EXTERNAL_UINT32_ARRAY_TYPE",
  143: "EXTERNAL_FLOAT32_ARRAY_TYPE",
  144: "EXTERNAL_FLOAT64_ARRAY_TYPE",
  145: "EXTERNAL_UINT8_CLAMPED_ARRAY_TYPE",
  146: "FIXED_INT8_ARRAY_TYPE",
  147: "FIXED_UINT8_ARRAY_TYPE",
  148: "FIXED_INT16_ARRAY_TYPE",
  149: "FIXED_UINT16_ARRAY_TYPE",
  150: "FIXED_INT32_ARRAY_TYPE",
  151: "FIXED_UINT32_ARRAY_TYPE",
  152: "FIXED_FLOAT32_ARRAY_TYPE",
  153: "FIXED_FLOAT64_ARRAY_TYPE",
  154: "FIXED_UINT8_CLAMPED_ARRAY_TYPE",
  156: "FILLER_TYPE",
  157: "DECLARED_ACCESSOR_DESCRIPTOR_TYPE",
  158: "DECLARED_ACCESSOR_INFO_TYPE",
  159: "EXECUTABLE_ACCESSOR_INFO_TYPE",
  160: "ACCESSOR_PAIR_TYPE",
  161: "ACCESS_CHECK_INFO_TYPE",
  162: "INTERCEPTOR_INFO_TYPE",
  163: "CALL_HANDLER_INFO_TYPE",
  164: "FUNCTION_TEMPLATE_INFO_TYPE",
  165: "OBJECT_TEMPLATE_INFO_TYPE",
  166: "SIGNATURE_INFO_TYPE",
  167: "TYPE_SWITCH_INFO_TYPE",
  169: "ALLOCATION_MEMENTO_TYPE",
  168: "ALLOCATION_SITE_TYPE",
  170: "SCRIPT_TYPE",
  171: "CODE_CACHE_TYPE",
  172: "POLYMORPHIC_CODE_CACHE_TYPE",
  173: "TYPE_FEEDBACK_INFO_TYPE",
  174: "ALIASED_ARGUMENTS_ENTRY_TYPE",
  175: "BOX_TYPE",
  184: "PROTOTYPE_INFO_TYPE",
  178: "FIXED_ARRAY_TYPE",
  155: "FIXED_DOUBLE_ARRAY_TYPE",
  179: "CONSTANT_POOL_ARRAY_TYPE",
  180: "SHARED_FUNCTION_INFO_TYPE",
  182: "WEAK_CELL_TYPE",
  188: "JS_MESSAGE_OBJECT_TYPE",
  187: "JS_VALUE_TYPE",
  189: "JS_DATE_TYPE",
  190: "JS_OBJECT_TYPE",
  191: "JS_CONTEXT_EXTENSION_OBJECT_TYPE",
  192: "JS_GENERATOR_OBJECT_TYPE",
  193: "JS_MODULE_TYPE",
  194: "JS_GLOBAL_OBJECT_TYPE",
  195: "JS_BUILTINS_OBJECT_TYPE",
  196: "JS_GLOBAL_PROXY_TYPE",
  197: "JS_ARRAY_TYPE",
  198: "JS_ARRAY_BUFFER_TYPE",
  199: "JS_TYPED_ARRAY_TYPE",
  200: "JS_DATA_VIEW_TYPE",
  186: "JS_PROXY_TYPE",
  201: "JS_SET_TYPE",
  202: "JS_MAP_TYPE",
  203: "JS_SET_ITERATOR_TYPE",
  204: "JS_MAP_ITERATOR_TYPE",
  205: "JS_WEAK_MAP_TYPE",
  206: "JS_WEAK_SET_TYPE",
  207: "JS_REGEXP_TYPE",
  208: "JS_FUNCTION_TYPE",
  185: "JS_FUNCTION_PROXY_TYPE",
  176: "DEBUG_INFO_TYPE",
  177: "BREAK_POINT_INFO_TYPE",
}

# List of known V8 maps.
KNOWN_MAPS = {
  0x08081: (135, "ByteArrayMap"),
  0x080ad: (129, "MetaMap"),
  0x080d9: (131, "NullMap"),
  0x08105: (178, "FixedArrayMap"),
  0x08131: (4, "OneByteInternalizedStringMap"),
  0x0815d: (136, "FreeSpaceMap"),
  0x08189: (156, "OnePointerFillerMap"),
  0x081b5: (156, "TwoPointerFillerMap"),
  0x081e1: (131, "UndefinedMap"),
  0x0820d: (132, "HeapNumberMap"),
  0x08239: (131, "TheHoleMap"),
  0x08265: (131, "BooleanMap"),
  0x08291: (131, "UninitializedMap"),
  0x082bd: (181, "CellMap"),
  0x082e9: (183, "GlobalPropertyCellMap"),
  0x08315: (180, "SharedFunctionInfoMap"),
  0x08341: (133, "MutableHeapNumberMap"),
  0x0836d: (178, "NativeContextMap"),
  0x08399: (130, "CodeMap"),
  0x083c5: (178, "ScopeInfoMap"),
  0x083f1: (178, "FixedCOWArrayMap"),
  0x0841d: (155, "FixedDoubleArrayMap"),
  0x08449: (179, "ConstantPoolArrayMap"),
  0x08475: (182, "WeakCellMap"),
  0x084a1: (68, "OneByteStringMap"),
  0x084cd: (178, "FunctionContextMap"),
  0x084f9: (131, "NoInterceptorResultSentinelMap"),
  0x08525: (131, "ArgumentsMarkerMap"),
  0x08551: (131, "ExceptionMap"),
  0x0857d: (131, "TerminationExceptionMap"),
  0x085a9: (178, "HashTableMap"),
  0x085d5: (178, "OrderedHashTableMap"),
  0x08601: (128, "SymbolMap"),
  0x0862d: (64, "StringMap"),
  0x08659: (69, "ConsOneByteStringMap"),
  0x08685: (65, "ConsStringMap"),
  0x086b1: (67, "SlicedStringMap"),
  0x086dd: (71, "SlicedOneByteStringMap"),
  0x08709: (66, "ExternalStringMap"),
  0x08735: (74, "ExternalStringWithOneByteDataMap"),
  0x08761: (70, "ExternalOneByteStringMap"),
  0x0878d: (70, "NativeSourceStringMap"),
  0x087b9: (82, "ShortExternalStringMap"),
  0x087e5: (90, "ShortExternalStringWithOneByteDataMap"),
  0x08811: (0, "InternalizedStringMap"),
  0x0883d: (2, "ExternalInternalizedStringMap"),
  0x08869: (10, "ExternalInternalizedStringWithOneByteDataMap"),
  0x08895: (6, "ExternalOneByteInternalizedStringMap"),
  0x088c1: (18, "ShortExternalInternalizedStringMap"),
  0x088ed: (26, "ShortExternalInternalizedStringWithOneByteDataMap"),
  0x08919: (22, "ShortExternalOneByteInternalizedStringMap"),
  0x08945: (86, "ShortExternalOneByteStringMap"),
  0x08971: (137, "ExternalInt8ArrayMap"),
  0x0899d: (138, "ExternalUint8ArrayMap"),
  0x089c9: (139, "ExternalInt16ArrayMap"),
  0x089f5: (140, "ExternalUint16ArrayMap"),
  0x08a21: (141, "ExternalInt32ArrayMap"),
  0x08a4d: (142, "ExternalUint32ArrayMap"),
  0x08a79: (143, "ExternalFloat32ArrayMap"),
  0x08aa5: (144, "ExternalFloat64ArrayMap"),
  0x08ad1: (145, "ExternalUint8ClampedArrayMap"),
  0x08afd: (147, "FixedUint8ArrayMap"),
  0x08b29: (146, "FixedInt8ArrayMap"),
  0x08b55: (149, "FixedUint16ArrayMap"),
  0x08b81: (148, "FixedInt16ArrayMap"),
  0x08bad: (151, "FixedUint32ArrayMap"),
  0x08bd9: (150, "FixedInt32ArrayMap"),
  0x08c05: (152, "FixedFloat32ArrayMap"),
  0x08c31: (153, "FixedFloat64ArrayMap"),
  0x08c5d: (154, "FixedUint8ClampedArrayMap"),
  0x08c89: (178, "SloppyArgumentsElementsMap"),
  0x08cb5: (178, "CatchContextMap"),
  0x08ce1: (178, "WithContextMap"),
  0x08d0d: (178, "BlockContextMap"),
  0x08d39: (178, "ModuleContextMap"),
  0x08d65: (178, "ScriptContextMap"),
  0x08d91: (178, "ScriptContextTableMap"),
  0x08dbd: (188, "JSMessageObjectMap"),
  0x08de9: (134, "ForeignMap"),
  0x08e15: (190, "NeanderMap"),
  0x08e41: (190, "ExternalMap"),
  0x08e6d: (169, "AllocationMementoMap"),
  0x08e99: (168, "AllocationSiteMap"),
  0x08ec5: (172, "PolymorphicCodeCacheMap"),
  0x08ef1: (170, "ScriptMap"),
  0x0907d: (175, "BoxMap"),
  0x090a9: (159, "ExecutableAccessorInfoMap"),
  0x090d5: (160, "AccessorPairMap"),
  0x09101: (161, "AccessCheckInfoMap"),
  0x0912d: (162, "InterceptorInfoMap"),
  0x09159: (163, "CallHandlerInfoMap"),
  0x09185: (164, "FunctionTemplateInfoMap"),
  0x091b1: (165, "ObjectTemplateInfoMap"),
  0x091dd: (167, "TypeSwitchInfoMap"),
  0x09209: (171, "CodeCacheMap"),
  0x09235: (173, "TypeFeedbackInfoMap"),
  0x09261: (174, "AliasedArgumentsEntryMap"),
  0x0928d: (176, "DebugInfoMap"),
  0x092b9: (177, "BreakPointInfoMap"),
  0x092e5: (184, "PrototypeInfoMap"),
}

# List of known V8 objects.
KNOWN_OBJECTS = {
  ("OLD_SPACE", 0x08081): "NullValue",
  ("OLD_SPACE", 0x08091): "EmptyDescriptorArray",
  ("OLD_SPACE", 0x08099): "EmptyFixedArray",
  ("OLD_SPACE", 0x080b1): "UndefinedValue",
  ("OLD_SPACE", 0x080d9): "NanValue",
  ("OLD_SPACE", 0x080e5): "TheHoleValue",
  ("OLD_SPACE", 0x08105): "TrueValue",
  ("OLD_SPACE", 0x08125): "FalseValue",
  ("OLD_SPACE", 0x08149): "empty_string",
  ("OLD_SPACE", 0x08155): "UninitializedValue",
  ("OLD_SPACE", 0x08181): "EmptyByteArray",
  ("OLD_SPACE", 0x08189): "EmptyConstantPoolArray",
  ("OLD_SPACE", 0x08199): "NoInterceptorResultSentinel",
  ("OLD_SPACE", 0x081d5): "ArgumentsMarker",
  ("OLD_SPACE", 0x08201): "Exception",
  ("OLD_SPACE", 0x08229): "TerminationException",
  ("OLD_SPACE", 0x0825d): "NumberStringCache",
  ("OLD_SPACE", 0x08a65): "SingleCharacterStringCache",
  ("OLD_SPACE", 0x08efd): "StringSplitCache",
  ("OLD_SPACE", 0x09305): "RegExpMultipleCache",
  ("OLD_SPACE", 0x0970d): "EmptyExternalInt8Array",
  ("OLD_SPACE", 0x09719): "EmptyExternalUint8Array",
  ("OLD_SPACE", 0x09725): "EmptyExternalInt16Array",
  ("OLD_SPACE", 0x09731): "EmptyExternalUint16Array",
  ("OLD_SPACE", 0x0973d): "EmptyExternalInt32Array",
  ("OLD_SPACE", 0x09749): "EmptyExternalUint32Array",
  ("OLD_SPACE", 0x09755): "EmptyExternalFloat32Array",
  ("OLD_SPACE", 0x09761): "EmptyExternalFloat64Array",
  ("OLD_SPACE", 0x0976d): "EmptyExternalUint8ClampedArray",
  ("OLD_SPACE", 0x09779): "EmptyFixedUint8Array",
  ("OLD_SPACE", 0x09781): "EmptyFixedInt8Array",
  ("OLD_SPACE", 0x09789): "EmptyFixedUint16Array",
  ("OLD_SPACE", 0x09791): "EmptyFixedInt16Array",
  ("OLD_SPACE", 0x09799): "EmptyFixedUint32Array",
  ("OLD_SPACE", 0x097a1): "EmptyFixedInt32Array",
  ("OLD_SPACE", 0x097a9): "EmptyFixedFloat32Array",
  ("OLD_SPACE", 0x097b1): "EmptyFixedFloat64Array",
  ("OLD_SPACE", 0x097b9): "EmptyFixedUint8ClampedArray",
  ("OLD_SPACE", 0x097c1): "InfinityValue",
  ("OLD_SPACE", 0x097cd): "MinusZeroValue",
  ("OLD_SPACE", 0x097d9): "MessageListeners",
  ("OLD_SPACE", 0x097f5): "CodeStubs",
  ("OLD_SPACE", 0x0c799): "KeyedLoadDummyVector",
  ("OLD_SPACE", 0x1110d): "ArrayProtector",
  ("OLD_SPACE", 0x11f51): "NonMonomorphicCache",
  ("OLD_SPACE", 0x12295): "PolymorphicCodeCache",
  ("OLD_SPACE", 0x1229d): "NativesSourceCache",
  ("OLD_SPACE", 0x1252d): "ExperimentalNativesSourceCache",
  ("OLD_SPACE", 0x12559): "EmptyScript",
  ("OLD_SPACE", 0x12595): "IntrinsicFunctionNames",
  ("OLD_SPACE", 0x21135): "UndefinedCell",
  ("OLD_SPACE", 0x2113d): "ObservationState",
  ("OLD_SPACE", 0x21149): "SymbolRegistry",
  ("OLD_SPACE", 0x21755): "EmptySlowElementDictionary",
  ("OLD_SPACE", 0x2177d): "AllocationSitesScratchpad",
  ("OLD_SPACE", 0x21b85): "WeakObjectToCodeTable",
  ("OLD_SPACE", 0x4af2d): "StringTable",
  ("CODE_SPACE", 0x18061): "JsConstructEntryCode",
  ("CODE_SPACE", 0x22d61): "JsEntryCode",
}
