# io.js TC Meeting 2015-04-08

## Links

* **Public YouTube feed**: http://www.youtube.com/watch?v=OjlK8k10oyo
* **Google Plus Event page**: https://plus.google.com/events/c1c3234uog6svplgrapqucb557k
* **GitHub Issue**: https://github.com/iojs/io.js/issues/1369
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1EsDjfRGpVKFABH4LcNXNxsAsBTnHsU-i5cehmAcp1A8

## Agenda

Extracted from https://github.com/iojs/io.js/labels/tc-agenda prior to meeting.

* [#1101](https://github.com/iojs/io.js/pull/1101) http: allow HTTP to return an HTTPS server / @silverwind / the use of a `tls` option to trigger `https` module functionality
* [#1301](https://github.com/iojs/io.js/pull/1301) Util(.is*) Deprecations / @Fishrock123 & @brendanashworth / [this comment](https://github.com/iojs/io.js/pull/1301#issuecomment-90829575) asking for an opinion from the TC on how to move forward
* Discuss https://github.com/jasnell/dev-policy [[comment by @mikeal]](https://github.com/iojs/io.js/issues/1369#issuecomment-90955688)
* Discuss / Review the `require(‘.’)` situation [[comments by @silverwind and @Fishrock123]](https://github.com/iojs/io.js/issues/1369#issuecomment-90933134)


### Present

* Bert (TC)
* Domenic
* Trevor (TC)
* Ben (TC)
* Fedor (TC)
* Jeremiah
* Mikeal
* Chris (TC)

### Review of last meeting

* reconciliation update (Mikeal and Bert)
* doc: add NAN WG [#1226](https://github.com/iojs/io.js/issues/1226)
* Proposal: Authorise @Fishrock123 to create releases  [#1225](https://github.com/iojs/io.js/issues/1225)
* governance: Raise the bar for changes in membership and governance policy.  [#1222](https://github.com/iojs/io.js/issues/1222)
* Nominating Rod Vagg @rvagg to the TC  [#1134](https://github.com/iojs/io.js/issues/1131)

### Quick stand-up

* Ben: fixing bugs, reviewing PRs. Looked into adding `Generator.prototype.return()` in V8, but more complicated than expected (crashes and can’t figure out why). Fedor might help.
* Bert: working on a CI status dashboard. Reviewing a patch that makes Node use Chakra instead of V8 (!)
* Chris: worked on a patch to add a UTF8 consumer to utils, for the purposes of eventually adding UTF8 validation as well as being able to externalize buffer-strings. Talked about standardizing destroy() behavior on streams
* Domenic: Not much on io.js, reviewed some dev policy stuff especially with regard to V8
* Fedor: bugs and PRs
* Jeremiah: bugs and PRs and 1.6.4 release
* Mikeal: worked on dev policy for the foundation, continuing to iterate; distilling feedback from worried-about-reconciliation thread, but had to lock it in the end with links to other places to address such things.
* Trevor: code reviews

## Minutes

### [#1101](https://github.com/iojs/io.js/pull/1101) http: allow HTTP to return an HTTPS server

***@silverwind / the use of a `tls` option to trigger `https` module functionality***

Jeremiah: two options we have (that we’ve discussed) are a tls option, or just auto-detect if you provide appropriate options.

Ben: why is this a TC issue?

Jeremiah/Domenic: three or four weeks without consensus.

Mikeal: related to issue in NG, where you could pass options to listen() instead of createServer().

Chris/Jeremiah: there is a PR for it in joyent/node; not merged yet.

Fedor: to me the problem is `http.request` vs. `https.request`.

Mikeal: (advocates for .listen again)

Trevor: -1 for doing it .listen; it’s too complicated internally; there is lots of weirdness going on here already.

Fedor: would be harder to share a server among workers in a cluster.

DD: but this particular PR is just a simple change to allow you to avoid having to decide between require('http') vs. require('https').

Bert: I kind of like the version where you put the options in listen().

Ben: what happens when iojs is compiled without TLS support?

**Conclusion**: punt on this. Initial feedback is that if we were to go down this route, we would slightly prefer the explicit tls option; however, there needs to be a discussion about the listen() idea, and also about compilation without TLS.

### [#1301](https://github.com/iojs/io.js/pull/1301) Util(.is*) Deprecations

***@Fishrock123 & @brendanashworth / [this comment](https://github.com/iojs/io.js/pull/1301#issuecomment-90829575) asking for an opinion from the TC on how to move forward***

Bert: what’s the point?

Trevor: that we won’t really fix bugs in these.

Mikeal: this is just in the docs?

Ben: also util.deprecate to log a warning

Mikeal: that just sounds annoying

Trevor: it’s supposed to be; fix your code

Mikeal: yeah but it’s not always your code…

Bert: we already have two levels of deprecation, warning and not warning

Domenic: however we only use the latter for domains, since we don’t have an alternative for them

Mikeal: can we do staged deprecations, marking things in the docs for one major release cycle, then in the next major release cycle start warning

Domenic: could we add an option to show the deprecation warnings for people who are contentious?

Mikeal: I don’t think anyone would actually turn that on…

Chris: I might be able to run my tooling over all of npm to detect uses

Bert: we need a better strategy in general for moving things out of core. The reason we want to deprecate these is that we don’t really want to fix it because that would be backward incompatible, so this is really too big to be in core. Any ideas for making these better? Maybe if you install a module called util it can take precedence over the one in node? So then we can release the fixed one on npm?

Mikeal: that does sound better than versioning core modules … we hit a flag that lets you replace the core one with a new one. Over time we’ll be able to get data.

Bert: there were some talks about doing this in browsers?

Domenic: not really, nobody wants to ship two versions.

**Conclusions: mark util.isXYZ deprecated in the docs, but do not show a warning in the console this version**

### [Dev Policy](https://github.com/jasnell/dev-policy)

Chris: looking good to me, on the right path, some minor issues still being worked out. E.g. around using priority tags and ways to funnel work to smaller number of contributors in joyent/node vs. just adding more contributors as we do.

Jeremiah: Node has a CI Jenkins PR integration thing that they are in favor of using

Domenic: honestly anything that prevents people from committing things that turn the build red would be awesome…

Bert: agree.

Bert: there’s an issue about version numbers

Mikeal: if we merge, it’ll be a 2.0.0, and we’ll bring in the backward incompatible changes we’ve been sitting on for a while

Mikeal: more on this tomorrow, audio will be public after it happens (due to technology being used it won’t be live). Please review dev policy beforehand.

### Isaac

Ben: Isaac doesn’t seem to be involved anymore. What do we do when a TC member goes AWOL?

Mikeal: well, we cancelled two meetings he was ready to attend, and then he went on vacation for two weeks, so AWOL isn’t quite the right characterization… But yeah, he’s not doing too much. We can just ask if he wants to be there, or we can vote it off.

Bert: I asked him and didn’t get an extremely clear answer; we’ll probably get more clarity when he’s back from vacation. I would not suggest throwing him off right now.

Ben: yeah, there’s no urgency, just…

Bert: yes, but I agree that if you’re on the TC you should show up to meetings

Fedor: what if we made votes exponentially decay in power based on attendance…

### `require('.')`

Mikeal: if we knew the impact of this change would we have done a major?

Chris: if we would have done a major we wouldn’t have done it at all because the API is locked and only bugfixes are allowed.

Jeremiah: that being said the only thing that breaks is a strange workflow from an undocumented feature.

Ben: I am not very sympathetic to that argument; we broke someone’s workflow, and that’s bad.

Domenic: I don’t think that’s fair. Every change is breaking to someone; even changing error messages will break people who parse error messages. The question is what side of the line this is on.

Mikeal: it seemed weird…

Domenic: I always thought NODE_PATH was deprecated. Should we warn about people using it?

Ben: I understand that someone is already using the new require behavior, so reverting it would be backward-incompatible. So we have a few options: 1) add a hack that makes NODE_PATH interactions with require('.') work as they used to; 2) say “sorry” and keep as-is

Bert: I’m sympathetic to adding the hack and a warning.

Domenic: agree. And maybe try to kill NODE_PATH in 3.x.

**Conclusion: hack plus a warning that shows up in this hacky case (“hey, you’re using the require-dot trick with NODE_PATH; we made it work because we’re nice people, but we want to take it away in 2.x, so gear up”). In 2.x, probably warn on any use of NODE_PATH at all.**

### Bert shows off his CI prototype

It’s pretty cool.

It groups tests in interesting ways that are useful. (OS, flakiness, …)

### Next meeting

* 2015-04-15
