# io.js TC Meeting 2014-12-10

## Agenda

Extracted from https://github.com/iojs/io.js/labels/tc-agenda prior to meeting.

* @chrisdickinson nomination to TC https://github.com/iojs/io.js/issues/51 
* Move readable-stream to iojs org and make authoritative source for io.js to pull _from_ https://github.com/iojs/io.js/issues/55 
* Deprecate domains https://github.com/iojs/io.js/issues/66 
* Decide how to go forward with caine https://github.com/iojs/io.js/issues/117 
*  Is it io.js, IO.js, or something else? https://github.com/iojs/io.js/issues/118
* Build automation update
* extending options from a prototype
https://github.com/iojs/io.js/issues/62
* Separate I/O tests from simple, so simple tests can be run in parallel
* Statement / stance from TC on exposing a Promises API https://github.com/iojs/io.js/issues/11 

## Links

* **Google Hangouts Video**: https://www.youtube.com/watch?v=otE4IRMVUMo
* **GitHub Issue**: https://github.com/iojs/io.js/issues/112
* **Original Minutes Google Doc**: https://www.youtube.com/watch?v=otE4IRMVUMo

## Minutes

### Present

* Rod Vagg (facilitator, build representative)
* Ben Noordhuis (TC)
* Bert Belder (TC)
* Chris Dickinson (nominee to TC)
* Fedor Indutny (TC)
* Trevor Norris (TC)


### @chrisdickinson nomination to TC

https://github.com/iojs/io.js/issues/51 

**Unanimous decision to add Chris to TC**

### Move readable-stream to iojs org and make authoritative source for io.js to pull _from_

https://github.com/iojs/io.js/issues/55 

* Chris expressed concerns on doing this, but a -0 for now, give it a go and see how it works
* Discussed the potential difference with joyent/node
* Trevor discussed concerns about the tight coupling of streams to core
* Rod talked about organisational and community concerns
* No -1’s on moving the source of authoritative code and moving readable-stream into iojs
* Need to experiment with the flow: code, issues, docs, etc.
* **Consensus reached on moving readable-stream to iojs and flipping the authoritative code and doc flow**
* Chris and Rod to work on the process in GitHub

### Deprecate domains

https://github.com/iojs/io.js/issues/66 

* Trevor: domains are horrible but we don’t have a good alternative yet
* Ben: +1 on removal but don’t have a good story on what to tell people to use
* Bert: -1, would rather clean up docs to be honest about how it doesn’t do what it was hoped to
* Trevor: domains inhibit progress because of their invasiveness
* Discussed how to document concerns etc.
* Discussed https://github.com/iojs/io.js/pull/15 which adjusts the domain.run() API
* Agreed:
  - Accept PR #15
  - **Document that domains are on the way out: soft deprecation** (no util.deprecate())

### Decide how to go forward with Caine (bot)

https://github.com/iojs/io.js/issues/117 

* Fedor talked about _what_ caine is and _why_ it exists: too many emails from the repo, want to set up a system where relevant people are pulled into particular issues rather than having to subscribe to the repo for all notifications
* Chris: primary concern with having an automated bot is the incoming experience for users (like having a join bot on IRC)
* Discussed notifications / labels / etc.
* Bert discussed using a “new” label for triage--automatically add to incoming issues and remove when the issues have been looked at / dealt with by a contributor.
* Trevor voted to **move the discussion to GitHub**


### Is it io.js, IO.js, or something else?

https://github.com/iojs/io.js/issues/118 

* Ben: lowercase is “objectively superior” (j/k)
* No disagreements, the name is “io.js”
* Ben: binary name suggestion “iojs” with symlink to “node”, lots of discussion in https://github.com/iojs/io.js/issues/43
* **No disagreements, binary name will be “iojs”**
* Ben: how do we handle it on Windows? .bat file (problems with arg forwarding), small .exe
* Agreed to open a new issue to discuss Windows compat (Ben)

### Build automation update

Rod gave a summary of build project status:
 - Containerized build system is being improved by an active team in the https://github.com/iojs/build-containers repo, on target to enable automatic PR tests and status reports back to GitHub (will likely just be Linux distros for the forseeable future)
 - Next step is to enable committers to be able to trigger full builds across the build cluster
 - Aiming for more automation for a mid-January release, have concerns about Windows and OSX signing and the need for signing keys and how complex they are.
 - Chris Lea is working towards nightly builds for .deb-based systems (RHEL / Fedora based systems could come later but the assumption is that people running those systems are _less_ likely to want nightlies)
 - https://github.com/iojs/io.js/issues/13 is an ARM build failure that still needs attention to have ARM part of the build mix and not constantly fail (see https://jenkins-node-forward.nodesource.com for some ARM failures)


### Extending options from a prototype

https://github.com/iojs/io.js/issues/62

* Chris is asking for input
* Ben: we’re currently only looking at the object’s own properties, and ignoring properties on the prototype.
* Fedor: in general there’s no reason to explicitly check whether properties are on the object or on the prototype chain.
* Ben: **continue in the issue tracker**
* Bert: be consistent. Slightly agree with fedor.

### Separate I/O tests from simple, so simple tests can be run in parallel

* Fedor: discussed the possibility of moving out net and possibly fs tests so the rest can be parallelized. There may be problems with many of the fs tests because they use fixtures.
* Fedor: **agreed to try it out**
* Bert: preference for the “tests” target to run the current test target

### Statement / stance from TC on exposing a Promises API

https://github.com/iojs/io.js/issues/11 

* Rod: can we come up with some kind of statement from the TC regarding the possibility of adding a Promises API to core, even if it’s vague
* Bert: there’s a convergence of functionality around Promises that are making them more useful in conjunction with other ES6/ES7 features, TC should be _open_ to adding a Promises API in the future
* Trevor: would like to simplify the current API so that it’s easier to extend and add abstractions on the top
* Ben: when simplifying, it would be good to have a target for how the simplification can be used, Promises could be one of those
* Bert: It would be weird for Node to go its own path if the rest of the JS ecosystem were to go that way
* Rod & Bert: suggested a statement along the lines of: **Promises doesn’t make sense right now, so it’s not going to happen in the short-term, but the TC is open to change as things evolve in ES6 and ES7 and practical issues are worked out, TC is open to  experimentation, a _callback API is unlikely to ever go away_**
* Ben: a +0
* Trevor: pending practical concerns
* Fedor: a -0
* Chris: +0


###  Working with nvm, nvmw and similar installation managers

https://github.com/iojs/io.js/issues/40 

* Ben: suggested a dist.iojs.org for hosting binaries
* Ben: suggested a release.txt 
* Rod: **leave it up to the build team to work out the mechanics of releases and release.txt and/or release.json and come back to TC for approval or adjustments prior to formal release** (i.e. no need to bikeshed on this here right now)
