subroutine uv_addnoise(line,comm,error)
  use gildas_def
  use gkernel_interfaces
  use gbl_message
  use clean_types
  use clean_arrays
  use imager_interfaces, only : map_message, uv_new_data
  !---------------------------------------------------------------------
  ! IMAGER    
  !   ADD_NOISE Value [Bandwidth [Wcol]] /FILE InputFile OutputFile
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line
  character(len=*), intent(in) :: comm
  logical, intent(inout) :: error
  !
  integer, parameter :: o_file=1
  character(len=*), parameter :: rname='UV_ADDNOISE'
  ! Local
  type(gildas) :: hin,hou
  character(len=filename_length) :: uvin, uvou 
  type(gfits_hdesc_t) :: fd   ! FITS descriptor (unused here)
  !
  integer :: sblock=1000      ! Can be more efficient by computing it...
  integer :: i,nc,nv,j,k,l, wcol, ier, nin, nou
  real :: factor, noise, weight, band
  real(8) :: old_weight
  real, allocatable :: wdata(:)
  !
  call sic_r4(line,0,1,noise,.true.,error)
  if (error) return
  if (noise.eq.0) then
    if (sic_present(o_file,0)) then
      call map_message(seve%e,rname,'No noise being added, no new file created')
      error = .true.
      return
    else
      call map_message(seve%i,rname,'No noise being added, reloading noise-free model')
    endif
    weight = 1.0
  else
    weight = 1e-6/noise**2
  endif
  band = 0.
  call sic_r4(line,0,2,band,.false.,error)
  if (error) return
  wcol = 0
  call sic_i4(line,0,3,wcol,.false.,error)
  !
  if (sic_present(o_file,0)) then
    ! /FILE option, use specified Input and Output UV table
    call sic_ch(line,o_file,1,uvin,nin,.true.,error)
    if (error) return
    call sic_ch(line,o_file,2,uvou,nou,.true.,error)
    if (error) return
    !
    ! Open line table
    call gildas_null (hin, type = 'UVT')
    call gdf_read_gildas (hin, uvin, '.uvt', error, data=.false.)
    if (error) then
      call map_message(seve%e,rname,'Cannot read input UV table')
      return
    endif
    !
    nc = hin%gil%nchan 
    if (wcol.le.0 .or. wcol.gt.nc) wcol = (nc+2)/3   ! Default channel
    wcol = hin%gil%fcol-1+3*wcol
    !
    hin%blc(1:2) = [wcol,0]
    hin%trc(1:2) = [wcol,0]
    allocate (wdata(hin%gil%dim(2)), hin%r2d(hin%gil%dim(1), sblock), stat=ier)
    if (ier.ne.0) then
      call map_message(seve%e,rname,'Memory allocation error')
      call gdf_close_image(hin,error)
      error = .true.
      return
    endif
    call gdf_read_data (hin, wdata, error)
    if (error) then
      call gdf_close_image(hin,error)
      error = .true.
      return
    endif
    hin%blc = 0
    hin%trc = 0
    !
    old_weight = 0.
    do i=1,hin%gil%nvisi
      if (wdata(i).gt.0) old_weight = old_weight + wdata(i)
    enddo
    if (band.eq.0.) band = abs(hin%gil%fres)
    if (old_weight.eq.0) then
      call map_message(seve%e,rname,'Selected weight channel has Zero weight')
      error = .true.
      return
    endif
    factor = weight / old_weight * abs(hin%gil%fres)/band
    !!Print *,'Weight ',weight
    !!Print *,'Old Weight ',old_weight
    !!Print *,'Resolution ',abs(hin%gil%fres),band
    !!Print *,'Factor ',factor
    !
    call gildas_null(hou,type='UVT')
    call gdf_copy_header(hin,hou,error)
    call sic_parsef (uvou, hou%file,' ','.uvt')
    call gdf_create_image(hou,error)
    if (error) then
      call gdf_close_image(hin,error)
      error = .true.
      return
    endif
    !
    ! Loop over line table
    do i=1,hin%gil%dim(2),sblock
      hin%blc(2) = i
      hin%trc(2) = min(hin%gil%dim(2),i-1+sblock)
      call gdf_read_data(hin,hin%r2d,error)
      !
      ! Add noise to this visibility range
      nv = hin%trc(2)-hin%blc(2)+1
      do j=1,nv
        weight = hin%r2d(wcol,j)
        if (weight.gt.0) then
          weight = weight*factor
          noise = 1e-3/sqrt(weight) 
          do k=1,nc
            l = hin%gil%fcol+3*(k-1)
            hin%r2d(l,j) = hin%r2d(l,j) + rangau(noise)
            l = l+1
            hin%r2d(l,j) = hin%r2d(l,j) + rangau(noise)
            l = l+1
            hin%r2d(l,j) = weight 
          enddo
        endif
      enddo  
      hou%blc = hin%blc
      hou%trc = hin%trc
      call gdf_write_data (hou, hin%r2d, error)
    enddo
    ! end loop
    call gdf_close_image (hin, error)
    call gdf_close_image (hou, error)
  else
    ! No /FILE option: Start from the MODEL_UV table,
    ! and overwrite the UV_DATA table.
    !
    if (.not.allocated(duvm)) then
      call map_message(seve%e,rname,'No MODEL_UV table in memory')
      error = .true.
      return
    endif
    !
    ! Discard the current UV_DATA table and overload it by the UV_MODEL
    call getset_uvdata('ADD_NOISE',huvm,duvm,fd,0,[0,0],0,error)
    !
    ! Update the content
    if (noise.gt.0) then
      nc = huvm%gil%nchan
      if (wcol.le.0 .or. wcol.gt.nc) wcol = (nc+2)/3   ! Default channel
      wcol = huvm%gil%fcol-1+3*wcol
      old_weight = 0.
      do i=1,huvm%gil%nvisi
        if (duvm(wcol,i).gt.0) old_weight = old_weight + duvm(wcol,i)
      enddo
      if (band.eq.0.) band = abs(huvm%gil%fres)
      factor = weight / old_weight * abs(huvm%gil%fres)/band
      !
      !$OMP PARALLEL DEFAULT(NONE) &
      !$OMP & SHARED(huvm,huvi,duvi,wcol,nc,factor) &
      !$OMP & PRIVATE(weight,j,k,l,noise)
      !$OMP DO
      do j=1,huvm%gil%nvisi
        weight = duvi(wcol,j)
        if (weight.gt.0) then
          weight = weight*factor
          noise = 1e-3/sqrt(weight)
          do k=1,nc
            l = huvi%gil%fcol+3*(k-1)
            duvi(l,j) = duvi(l,j) + rangau(noise)
            l = l+1
            duvi(l,j) = duvi(l,j) + rangau(noise)
            l = l+1
            duvi(l,j) = weight
          enddo
        endif
      enddo
      !$OMP ENDDO
      !$OMP END PARALLEL
    endif
    !
    call uv_new_data(weight=.true.)
    optimize(code_save_uv)%change = optimize(code_save_uv)%change+100
    !
  endif
end subroutine uv_addnoise
!
subroutine getset_uvdata(rname,head,datauv,fd,fits_fmt,nc,pcount,error)
  use clean_def
  use clean_arrays
  use clean_types
  use clean_beams
  use clean_default
  use uvfit_data
  use gbl_message
  use gkernel_interfaces
  use imager_interfaces, except_this=>getset_uvdata
  !
  !------------------------------------------------------------------
  ! @ private
  !
  ! IMAGER
  !   Read UV_DATA or get it from another buffer
  !------------------------------------------------------------------
  type (gildas), intent(inout) :: head    ! Header of input data
  character(len=*), intent(in) :: rname   ! Caller name
  real(kind=4), intent(in) :: datauv(head%gil%dim(1),head%gil%dim(2)) ! Data used to fill the values
  type(gfits_hdesc_t), intent(in) :: fd   ! FITS descriptor 
  integer, intent(in) :: fits_fmt         ! Input FITS file format
  integer, intent(in) :: nc(2)            ! Channel range
  integer, intent(in) :: pcount           ! Fits PCOUNT
  logical, intent(out) :: error
  !
  integer, parameter :: o_trail=5
  !
  integer :: local_nc(2)
  type(gildas) :: htmp
  integer :: i, ier, nchan, insize_uv
  character(len=80) :: mess
  integer :: ram_need
  logical :: readit
  !
  if (head%char%type(1:9).ne.'GILDAS_UV') then
    call map_message(seve%e,rname,'Input data is not a UV data set')
    error = .true.
    return
  endif
  readit = rname.eq."READ"
  !
  ! Free the previous zone
  call uv_free_buffers
  save_data(code_save_uv) = .false.
  ! No UV_PREVIEW done, then...
  call sic_delvariable('PREVIEW',.false.,error)
  call reset_fields(themap)
  !
  error = .false.
  !
  call gildas_null (huvi, type= 'UVT')
  call gildas_null (htmp, type= 'UVT')
  call gdf_copy_header(head, htmp, error)
  ! Check appropriate order
  if (head%char%code(1).eq."RANDOM") then
    call map_message(seve%w,rname,'UV data is transposed')
    call gdf_transpose_header (htmp, huvi, '21', error)
  else
    call gdf_copy_header(head, huvi, error)
  endif
  if (error)  return
  htmp%loca = head%loca
  huvi%loca  = head%loca   ! Why : to get the image slot !...
  !
  call sic_delvariable ('UV',.false.,error)
  call sic_delvariable ('UVS',.false.,error)
  call sic_delvariable ('DCHANFLAG',.false.,error)
  !
  ! Extract desired channels
  nchan = huvi%gil%nchan
  !
  if (readit) then
    local_nc = nc
    ier = gdf_range (local_nc, nchan)
    nchan = local_nc(2)-local_nc(1)+1
    huvi%gil%ref(1) = huvi%gil%ref(1)-local_nc(1)+1
    huvi%gil%dim(1) = huvi%gil%nlead+huvi%gil%natom*huvi%gil%nstokes*nchan
    !
    insize_uv = huvi%gil%dim(1)
    if (fits_fmt.eq.1) then
      insize_uv = huvi%gil%nlead+huvi%gil%natom*nchan
    endif
    !
    ! Only for READ command
    if (huvi%gil%ntrail.gt.0) then
      if (sic_present(o_trail,0).or.(.not.read_trail)) then    ! /NOTRAIL option
        do i=1,code_uvt_last
          if (huvi%gil%column_pointer(i).gt.huvi%gil%dim(1)) then
            call map_message(seve%w,rname,'Found column '//uv_column_name(i))
            huvi%gil%column_size(i) = 0
            huvi%gil%column_pointer(i) = 0
          endif
        enddo
        huvi%gil%ntrail = 0
      endif
      ! use them according to user selection
      huvi%gil%dim(1) = huvi%gil%dim(1) + huvi%gil%ntrail
    endif
    insize_uv = insize_uv+huvi%gil%ntrail
    !
    huvi%gil%nchan = nchan
    !
    ram_need = (huvi%gil%dim(1)*huvi%gil%dim(2))/(512*512)   ! Size of RAM requested
    if (ram_need.gt.sys_ramsize) then
      write(mess,'(A,F8.1,A,F8.1,A)') 'Data size (',1d-3*ram_need, &
        & 'GB) exceeds available RAM (',1d-3*sys_ramsize,' GB)'
      call map_message(seve%e,rname,mess,1)
      error = .true.
      return
    else if (ram_need.gt.sys_ramsize/3) then
      write(mess,'(A,F8.1,A,F8.1,A)') 'Data size (',1d-3*ram_need, &
        & 'GB) exceeds 1/3rd  of available RAM (',1d-3*sys_ramsize,' GB)'
      call map_message(seve%w,rname,mess,3)
    endif
    !
    allocate(duvi(insize_uv,huvi%gil%dim(2)),stat=ier)
    call map_read_uvdataset(fd,fits_fmt,pcount,htmp,huvi,local_nc,duvi,error)
    if (error) then
      deallocate(duvi,stat=ier)
      return
    endif
    ! Additional information if any
    huvi%r2d => duvi     ! Set the pointer towards the UV data area
    call get_more_header(fits_fmt,head%file,huvi)
    !
  else
    ! Do not read it, just come back to data specified in call sequence
    allocate(duvi(huvi%gil%dim(1),huvi%gil%dim(2)),stat=ier)
    duvi(:,:) = datauv(:,:)
  endif
  ! Erase undefined part of visibility data
  if (huvi%gil%nvisi.lt.huvi%gil%dim(2)) then
    duvi(:,huvi%gil%nvisi+1:huvi%gil%dim(2)) = 0.
  endif
  !
  ! Check the type and number of fields
  call check_uvdata_type(rname,huvi,duvi,themap,error)
  if (error) return
  !
  ! Set the Channel Flags to 1 (good)
  allocate(dchanflag(nchan),stat=ier)
  dchanflag = 1
  call sic_def_inte('DCHANFLAG',dchanflag,1,nchan,.false.,error)
  !
  ! Finalize
  call gildas_null (huv, type = 'UVT')
  call gdf_copy_header(huvi,huv, error)
  huv%file = huvi%file     ! Transmit File name
  huv%r2d => duvi
  duv => duvi              ! Point on original data
  duvr => duvi             ! Point on original data
  !
  call map_uvgildas('UV',huv,error,duvi) 
  !
  ! Undo the Weights buffers also
  if (allocated(g_weight)) deallocate(g_weight)
  if (allocated(g_v)) deallocate(g_v)
  do_weig = .true.
  !
  ! Unload the PRIMARY array if defined
  call sic_delvariable ('PRIMARY',.false.,error)
  if (allocated(dprim)) deallocate(dprim,stat=ier)
  hprim%loca%size = 0
  !
  ! Delete the BEAM_RANGES array if any
  nbeam_ranges = -1    ! Beam ranges unchecked
  call sic_delvariable ('BEAM_RANGES',.false.,error)
  !
  ! Delete the SELF array if defined
  call sic_delvariable ('UVSELF',.false.,error)
  if (associated(duvself)) then
    if (associated(duvself,duvcalib)) then
      nullify(duvself)
    else
      deallocate(duvself,stat=ier)
    endif 
    hself%loca%size = 0
  endif
  call sic_delvariable('UVCALIB',.false.,error)
  if (allocated(duvcalib)) deallocate(duvcalib,stat=ier)
  hcalib%loca%size = 0
  !
  ! Delete the CONTINUUM array if defined
  call sic_delvariable ('UVCONT',.false.,error)
  if (allocated(duvc)) deallocate(duvc,stat=ier)
  huvc%loca%size = 0
  ! Delete the CONTINUUM image if defined
  call sic_delvariable ('CONTINUUM',.false.,error)
  if (allocated(dcont)) deallocate(dcont,stat=ier)
  hcont%loca%size = 0
  !
  ! Final warning for POLARIZATION
  if (huv%gil%nstokes.gt.1) then
    write(mess,'(A,I0,A)') 'UV data has ',huv%gil%nstokes,' polarization states, use STOKES command'
    call map_message(seve%w,rname,mess,1)
  endif
  !
  ! Final message
  if (readit) then  
    call map_message(seve%i,rname,'UV Data read')
  else
    call map_message(seve%i,rname,'UV Data loaded')
  endif
end subroutine getset_uvdata
