#! /bin/sh
Version=" "
Dest=" "
Branch="newgio"
#
if [ "$#" = "3" ] ; then
  Branch=$3
  Dest=$2
  Version=$1
elif [ "$#" = "2" ] ; then
  Dest=$2
  Version=$1
elif [ "$#" = "1" ] ; then
  Version=$1
  Dest=$1
elif [ "$#" = "0" ] ; then
  echo "Usage: source release.sh VersioName  [Short Name]"
  return 1
fi
#
# Move to RELEASE storage area
cd RELEASE
# Clone the GIT repository
rm -rf imager-src-$Version
git clone --branch $Branch https://forge.oasu.u-bordeaux.fr/ums-porea/projets/imager/alma_imager imager-src-$Version
# Prepare the "admin" files for MacPorts 
cd imager-src-$Version
echo "Converting to MacPorts script files in tree $PWD" 
cd Admin-Source
echo $PWD
source substitute.macport.sh
cd ../..
#
echo "Creating imager-$Version.tgz in tree $PWD"
rm imager-$Version.tgz
tar -cvzf imager-$Version.tgz --exclude imager-src-$Version/.git imager-src-$Version
if [ "$Dest" = "$Version" ] ; then
  echo "No link needed"
else
  rm imager-$Dest.tgz
  ln -s imager-$Version.tgz imager-$Dest.tgz
fi
echo "Pushing imager-$Dest.tgz to SHARE area "
#curl --user stephane:lab5804 -T imager-last.tgz https://dave.oasu.u-bordeaux.fr:5000/5964614a-44f2-47fd-ba18-5f155543044e/imager-last.tgz
# Now on https://share.oasu.u-bordeaux.fr/imager
curl --user stephane:lab5804 -T imager-$Dest.tgz https://share.oasu.u-bordeaux.fr/imager/imager-$Dest.tgz
echo "Updating get-and-install script"
cd ..
curl --user stephane:lab5804 -T get-and-install.sh  https://share.oasu.u-bordeaux.fr/imager/get-and-install.sh
#
