/*
 * Copyright (c) 2003 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

#import "NSArray(CreateArgv).h"

@implementation NSArray(CreateArgv)

- ( int )createArgv: ( char *** )argv
{
    int				i, ac = 0, count = [ self count ];
    char			**av;
    
    if ( self == nil || count == 0 ) {
        *argv = NULL;
        return( 0 );
    }
    
    if (( av = ( char ** )malloc( sizeof( char * ) * ( count + 1 ))) == NULL ) {
        NSLog( @"malloc: %s", strerror( errno ));
        exit( 2 );
    }
    
    for ( i = 0; i < count; i++ ) {
	if ( [[ self objectAtIndex: i ] isKindOfClass: [ NSString class ]] ) {
	    if (( av[ i ] = strdup(( char * )[[ self objectAtIndex: i ] 
					      UTF8String ] )) == NULL ) {
		NSLog( @"strdup: %s", strerror( errno ));
		exit( 2 );
	    }
	} else if ( [[ self objectAtIndex: i ]
		     isKindOfClass: [ NSNumber class ]] ) {
	    if (( av[ i ] = strdup( [[[ self objectAtIndex: i ]
				      stringValue ] UTF8String ] )) == NULL ) {
		NSLog( @"strdup: %s", strerror( errno ));
		exit( 2 );
	    }
	} else {
	    NSLog( @"createArgv: invalid object type" );
	    continue;
	}
	
        ac++;
    }
    av[ i ] = NULL;
    *argv = av;
    
    return( ac );
}

@end
