/*
Copyright (c) 2002 Regents of The University of Michigan.
All Rights Reserved.

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear
in supporting documentation, and that the name of The University
of Michigan not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission. This software is supplied as is without expressed or
implied warranties of any kind.

Research Systems Unix Group
The University of Michigan
c/o Wesley Craig
4251 Plymouth Road B1F2, #2600
Ann Arbor, MI 48105-2785

http://rsug.itd.umich.edu/software/ihook
ihook@umich.edu
*/

#import "LHString.h"

@implementation NSString(LHString)

+ ( NSString * )clockStringFromInteger: ( int )integer
{
    int			secs, mins, hrs;
    
    hrs = (( integer / 60 ) / 60 );
    mins = (( integer / 60 ) % 60 );
    secs = (( integer % 60 ) % 60 );
    
    return( [ NSString stringWithFormat: @"%.2d:%.2d:%.2d", hrs, mins, secs ] );
}

- ( BOOL )containsString: ( NSString * )substring
{
    return( [ self containsString: substring useCaseInsensitiveComparison: NO ] );
}

- ( BOOL )containsString: ( NSString * )substring useCaseInsensitiveComparison: ( BOOL )ci
{
    unsigned		mask;
    
    if ( substring == nil || self == nil ) return NO;
    
    if ( ci == YES ) mask = NSCaseInsensitiveSearch;
    else mask = NSLiteralSearch;
    
    if ( [ self rangeOfString: substring options: mask ].location != NSNotFound ) {
        return( YES );
    }
    return( NO );
}

- ( BOOL )beginsWithString: ( NSString * )string
	    caseInsensitive: ( BOOL )caseInsensitive
{
    NSStringCompareOptions	options = NSLiteralSearch;
    BOOL			match = NO;
    
    if ( string == nil ) {
	return( NO );
    }
    
    if ( caseInsensitive ) {
	options = NSCaseInsensitiveSearch;
    }
    
    if ( [ self rangeOfString: string options: options ].location == 0 ) {
	match = YES;
    }
    
    return( match );
}

- ( BOOL )beginsWithString: ( NSString * )string
{
    return( [ self beginsWithString: string caseInsensitive: NO ] );
}

@end
