//
//  HookOperation.h
//  iHook
//
//  Created by Andrew Mortensen on 7/14/08.
//  Copyright 2008 University of Michigan, The. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#define HOOK_OPERATION_EXECUTE	    ( 1 << 0 )
#define HOOK_OPERATION_CANCEL	    ( 1 << 1 )

@interface HookOperation : NSOperation
{
@private
    id		    controller;
    NSString	    *executable;
    NSArray	    *arguments;
    NSMutableArray  *inputQueue;
    
    NSUInteger	    hookTask;
    pid_t	    hookPid;
}

- ( id )initWithController: ( id )aController
	    executable: ( NSString * )anExecutable
	    arguments: ( NSArray * )args
	    inputQueue: ( NSMutableArray * )queue;

- ( id )initAuthorizedCancellationOfTaskWithPID: ( pid_t )pid
	    controller: ( id )aController;
	    
- ( void )executeHook;
- ( void )cancelHook;

@property(retain)   id		    controller;
@property(copy)	    NSString	    *executable;
@property(copy)	    NSArray	    *arguments;
@property(retain)   NSMutableArray *inputQueue;
@end
