//
//  AMAuthorization.h
//  rsm
//
//  Created by Andrew Mortensen on 6/23/08.
//  Copyright 2008 University of Michigan, The. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Security/Authorization.h>

@interface AMAuthorization : NSObject
{
    AuthorizationItem	    authorizationItem;
    AuthorizationRef	    authorizationRef;
    AuthorizationRights	    authorizationRights;
    AuthorizationFlags	    authorizationFlags;
}

+ ( AMAuthorization * )authorizationWithName: ( NSString * )name;
+ ( AMAuthorization * )authorizationWithName: ( NSString * )name
			        preAuthorize: ( BOOL )preAuthorize
			    allowInteraction: ( BOOL )allowInteraction
			        extendRights: ( BOOL )extendRights;
- ( AMAuthorization * )initWithName: ( NSString * )name;
- ( AMAuthorization * )initWithName: ( NSString * )name
		       preAuthorize: ( BOOL )preAuthorize
		   allowInteraction: ( BOOL )allowInteraction
		       extendRights: ( BOOL )extendRights;

- ( BOOL )authorize;
- ( BOOL )makeExternalForm: ( AuthorizationExternalForm * )externalForm;

@property(readonly) AuthorizationRef	    authorizationRef;
@property	    AuthorizationFlags	    authorizationFlags;
@property	    AuthorizationItem	    authorizationItem;
@property	    AuthorizationRights	    authorizationRights;

@end
