/* 
   This function parses the information given by either
   command line or config file. It mainly checks for
   file existance/writing permissions etc.
*/

#include "cuc.h"
#include <sys/utsname.h>

void checkInp(std::string logFile6, std::string htmlFile6, std::string htmlFile, std::string logFile, std::string ip6, std::string ip, bool &haveV6, std::string fbip, std::string fbip6, double &checkPint, bool &haveHTML, std::string pint, int interval, int dinterval, bool &haveV4, int &type, std::string errors, std::string errors6)
{  
  struct utsname u;
  uname (&u);
  
  if (ip.size() == 0 && ip6.size() == 0)
    {
#ifdef HAVE_IPV6
      cout << "Supply a valid IPv4 or IPv6 address, either by editing /usr/local/etc/icpld.conf or" << endl;
#endif
#ifndef HAVE_IPV6
      cout << "Supply a valid ip address, either by editing /usr/local/etc/icpld.conf or" << endl;
#endif
      cout << "use -ip <ip> at the command line. See icpld --help or man icpld for further" << endl;
      cout << "information on icpld usage." << endl;
      exit(EXIT_FAILURE);
    }

  if (ip6.size() > 0 && ip.size() == 0)
    type = 6;
  else if (ip6.size() == 0 && ip.size() > 0)
    type = 4;
     
#ifdef HAVE_IPV6
  if (((ip6.size() > 0) || (type == 6)) && (type != 4)){
    if(logFile6.size() == 0){
      cout << "You have to specify a file to log to." << endl;
      exit(EXIT_FAILURE);
    }
  ofstream testLog6(logFile6.c_str(), ios::app);
  if (!testLog6){
    cout << "Could not open IPv6 log: " << logFile6 << " for writing: " << strerror(errno) << endl;
    exit(EXIT_FAILURE);
  }
  testLog6.close();
  ofstream testErr6(errors6.c_str(), ios::app);
  if (!testErr6) {
    cout << "Could not open IPv6 error log: " << errors6 << " for writing: " << strerror(errno) << endl;
    exit(EXIT_FAILURE);
  }
  testErr6.close();

  if (htmlFile6.size() != 0) {
    if (((fileCheck (htmlFile6) == "NE") || (fileCheck (htmlFile6) == "ENP")) && (htmlFile6.size() != 0)){

      std::ofstream createHTML6 (htmlFile6.c_str (),ios::app);
      if (!createHTML6)
	{
	  cout << "Could not open IPv6 html file:  " << htmlFile6 << " for writing: " << strerror(errno) << endl;
	  exit(EXIT_FAILURE);
	}
      createHTML6 <<"<title>Connection performance for "<< u.	nodename << "</title>" <<endl;
      createHTML6 << "<html>" << endl <<	"<body>" << endl << "<pre>" <<	endl;
      createHTML6 <<"Log generated by <a href=\"http://icpld.northernmost.org\">"<< PACKAGE << "</a>" << endl;
      createHTML6.close ();

    }

  }

 


  }
#endif


  if (((fileCheck (htmlFile) == "NE")    || (fileCheck (htmlFile)) == "ENP") && (htmlFile.size() > 0)){
	std::ofstream createHTML (htmlFile.  c_str (),std::ios::	  app);
	if (!createHTML)
	  {
	    cout << "Could not open IPv4 htmlFile: " << htmlFile << " for writing: " << strerror(errno) << endl;
	    exit(EXIT_FAILURE);
	  }
	createHTML <<"<title>Connection performance for "<< u.	nodename << "</title>" <<endl;
	createHTML << "<html>" << endl <<	"<body>" << endl << "<pre>" <<	endl;
	createHTML <<"Log generated by <a href=\"http://icpld.northernmost.org\">"<< PACKAGE << "</a>" << endl;
	createHTML.close ();
  }







  if(ip6.size() >= 1)
    haveV6 = true;
  if (type == 4)
    haveV6 = false;
  if (ip.size() <= 1) 
    haveV4 = false;
  if (type == 6)
    haveV4 = false;

  if(haveV4){
    if (!verip (ip, 4))
      exit(EXIT_FAILURE);

    ofstream testErr(errors.c_str(), ios::app);
    if (!testErr) {
      cout << "Could not open IPv4 error log: " << errors << " for writing: " << strerror(errno) << endl;
      exit(EXIT_FAILURE);
    }
    testErr.close();
  


    ofstream testLog(logFile.c_str(), ios::app);
    if (!testLog){
      cout << "Could not open " << logFile << " for writing: " << strerror(errno) << endl;
      if (errno == EISDIR)
	cout << "This usually happens if you leave the logFile field empty in the configuration file" << endl;
      exit(EXIT_FAILURE);
    }
    testLog.close();
  }
  if (haveV6){
    if(!verip (ip6, 6))
      exit(EXIT_FAILURE);
  }

  if (fbip.size () != 0 && haveV4)
    {
      if (!verip (fbip, 4)){
	cout << "Fallback IPv4 address failed verification" << endl;
	exit(EXIT_FAILURE);
      }
    }

  if (fbip6.size() != 0 && haveV6)
    {
      if (!verip (fbip6, 6)){
	cout << "Fallback IPv6 address failed verification" << endl;
	exit(EXIT_FAILURE);
      }
    }

  checkPint = strtod (pint.c_str (), (char **) NULL);
  if (checkPint >= interval || checkPint >= dinterval)
    {
      cout << "pint=" << checkPint << endl << "interval=" <<	interval << endl;
      cout << "The value of pint may not exceed or be equal to the value of interval or dinterval" << endl;
      cout << "It should preferably be set a tad lower due to timeouts etc." << endl;
      exit(EXIT_FAILURE);
    }

  if (checkPint <= 0.2 && getuid () != 0)
    {
      cout << "Setting pint this low is incredibly unwise and requires root privilegies. Aborting.." << endl;
      exit(EXIT_FAILURE);
    }

  if (htmlFile.size () == 0)
    haveHTML = false;
  else{
    haveHTML = true; 
    if (fileCheck (htmlFile) == "NE"  || fileCheck (htmlFile) == "ENP")
      {
	std::ofstream createHTML (htmlFile. c_str (), std::ios::  app);
	createHTML <<	"<title>Connection performance for "	<< u.	nodename << "</title>" << endl;
	createHTML << "<html>" << endl<< "<body>" << endl <<	"<pre>" << endl;
	createHTML << "Log generated by <a href=\"http://icpld.northernmost.org\">"	<< PACKAGE << "</a>"	<< endl;
	createHTML.close ();
      }
  }  


#ifdef HAVE_IPV6

  if (htmlFile6.size() != 0){
    if (((fileCheck (htmlFile6) == "NE")  || (fileCheck (htmlFile6) == "ENP")) && (htmlFile6.size() != 0))
      {
	std::ofstream createHTML6 (htmlFile6. c_str (), std::ios::  app);
	if (!createHTML6)	{
	  cout << "Could not open IPv6 html file:  " << htmlFile6 << " for writing: " << strerror(errno) << endl;
	  exit (EXIT_FAILURE);
	}

	createHTML6 <<	"<title>Connection performance for "	<< u.nodename << "</title>" << endl;
	createHTML6 << "<html>" << endl<< "<body>" << endl <<	"<pre>" << endl;
	createHTML6 << "Log generated by <a href=\"http://icpld.northernmost.org\">" << PACKAGE << "</a>"	<< endl;
	createHTML6.close ();
      }
  }
  if (logFile6.size() != 0){
    if (logFile6 == htmlFile6){
      cout << "d'0h! It is not suitable to set both HTML formatted and plaintext log output to the same file." << endl;
      cout << "Use separate files and try again." << endl;
    }
  }
#endif



    if(logFile.size() != 0){
      if (logFile == htmlFile) 
	{
	  cout << "d'0h! It is not suitable to set both HTML formatted and plaintext log output to the same file." << endl;
	  cout << "Use separate files and try again." << endl;
	  exit (EXIT_FAILURE);
	}
    }



/* Everything seems OK! */






}
